/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.cache;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.audit.entity.AuditRoute;
import org.apache.inlong.audit.service.config.Configuration;
import org.apache.inlong.audit.service.datasource.AuditDataSource;
import org.apache.inlong.audit.service.entities.JdbcConfig;
import org.apache.inlong.audit.service.utils.JdbcUtils;
import org.apache.inlong.audit.utils.NamedThreadFactory;
import org.apache.inlong.audit.utils.RouteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuditRouteCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditRouteCache.class);
    private static final int PERIOD_MS = 60000;
    private static final String ADDRESS = "address";
    private static final String AUDIT_ID_INCLUDE = "audit_id_include";
    private static final String GROUP_ID_INCLUDE = "inlong_group_id_include";
    private static final String GROUP_ID_EXCLUDE = "inlong_group_id_exclude";
    private static final AuditRouteCache instance = new AuditRouteCache();
    private volatile ConcurrentHashMap<String, List<AuditRoute>> auditRouteCache = new ConcurrentHashMap();
    private AuditDataSource auditDataSource;
    private final ScheduledExecutorService timerExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("update-audit-route"));

    private AuditRouteCache() {
    }

    public void init() {
        String querySQL = Configuration.getInstance().get("audit.query.route.sql", "SELECT address, audit_id_include, inlong_group_id_include, inlong_group_id_exclude FROM audit_route_config WHERE status=1");
        try {
            this.auditDataSource = this.createDataSource();
        }
        catch (Exception e) {
            LOGGER.error("Failed to create DataSource in AuditRouteCache init", (Throwable)e);
        }
        this.timerExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.updateAuditRouteCache(querySQL);
            }
            catch (Exception e) {
                LOGGER.error("Exception occurred during audit route cache update", (Throwable)e);
            }
        }, 0L, 60000L, TimeUnit.MILLISECONDS);
    }

    private AuditDataSource createDataSource() {
        JdbcConfig jdbcConfig = JdbcUtils.buildMysqlConfig();
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(jdbcConfig.getDriverClass());
        dataSource.setUrl(jdbcConfig.getJdbcUrl());
        dataSource.setUsername(jdbcConfig.getUserName());
        dataSource.setPassword(jdbcConfig.getPassword());
        dataSource.setValidationQuery("SELECT 1");
        return new AuditDataSource(jdbcConfig.getJdbcUrl(), (DataSource)dataSource);
    }

    private void updateAuditRouteCache(String querySQL) {
        ConcurrentHashMap<String, List> auditRoutes = new ConcurrentHashMap<String, List>();
        try (Connection connection = this.auditDataSource.getDataSource().getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(querySQL);){
            while (resultSet.next()) {
                String address = resultSet.getString("address");
                if (address == null || address.trim().isEmpty()) continue;
                String auditId = StringUtils.trimToNull((String)resultSet.getString("audit_id_include"));
                String includeGroupId = StringUtils.trimToNull((String)resultSet.getString("inlong_group_id_include"));
                String excludeGroupId = StringUtils.trimToNull((String)resultSet.getString("inlong_group_id_exclude"));
                if (!(AuditRouteCache.isValidRegexOrLog((String)auditId) && AuditRouteCache.isValidRegexOrLog((String)includeGroupId) && AuditRouteCache.isValidRegexOrLog((String)excludeGroupId))) {
                    LOGGER.error("Skipping invalid regex entry: address={}, auditId={}, includeGroupId={}, excludeGroupId={}", new Object[]{address, auditId, includeGroupId, excludeGroupId});
                    continue;
                }
                AuditRoute data = new AuditRoute();
                data.setAddress(address);
                data.setAuditId(auditId);
                data.setInlongGroupIdsInclude(includeGroupId);
                data.setInlongGroupIdsExclude(excludeGroupId);
                auditRoutes.computeIfAbsent(address, key -> new ArrayList()).add(data);
            }
        }
        catch (SQLException e) {
            LOGGER.error("Failed to update audit route cache", (Throwable)e);
            return;
        }
        if (!auditRoutes.isEmpty()) {
            this.auditRouteCache = auditRoutes;
            LOGGER.info("AuditRouteCache update success. Cache size={}, Query size={}", (Object)this.auditRouteCache.size(), (Object)auditRoutes.size());
        } else {
            LOGGER.warn("Audit route list is empty; cache not updated.");
        }
    }

    private static boolean isValidRegexOrLog(String fieldName) {
        if (fieldName == null) {
            return true;
        }
        if (!RouteUtils.isValidRegex((String)fieldName)) {
            LOGGER.error("Invalid regex for field: {}", (Object)fieldName);
            return false;
        }
        return true;
    }

    public void shutdown() {
        try {
            this.timerExecutor.shutdown();
            if (!this.timerExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.timerExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Interrupted while shutting down AuditRouteCache timerExecutor", (Throwable)e);
        }
    }

    public List<AuditRoute> getData(String host) {
        List routes = (List)this.auditRouteCache.get(host);
        return routes == null ? Collections.emptyList() : routes;
    }

    public static AuditRouteCache getInstance() {
        return instance;
    }
}

