/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.config;

import java.io.FileInputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    public static final String DEFAULT_CONFIG_FILE = "conf/audit-service.properties";
    private static volatile Configuration conf = null;
    Properties properties = new Properties();

    private Configuration() {
        try (FileInputStream fileInputStream = new FileInputStream(DEFAULT_CONFIG_FILE);){
            this.properties.load(fileInputStream);
        }
        catch (Exception e) {
            LOGGER.error("Configuration has exception!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration getInstance() {
        if (conf != null) return conf;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (conf != null) return conf;
            conf = new Configuration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return conf;
        }
    }

    public String get(String key, String defaultValue) {
        Object value = this.properties.get(key);
        return value == null ? defaultValue : value.toString();
    }

    public boolean get(String key, boolean defaultValue) {
        Object value = this.properties.get(key);
        return value == null ? defaultValue : Boolean.parseBoolean((String)value);
    }

    public int get(String key, int defaultValue) {
        Object value = this.properties.get(key);
        return value == null ? defaultValue : Integer.parseInt((String)value);
    }

    public double get(String key, double defaultValue) {
        Object value = this.properties.get(key);
        return value == null ? defaultValue : Double.parseDouble((String)value);
    }

    public String get(String key) {
        Object value = this.properties.get(key);
        return value == null ? null : value.toString();
    }
}

