/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.node;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.inlong.audit.service.config.Configuration;
import org.apache.inlong.audit.service.entities.JdbcConfig;
import org.apache.inlong.audit.service.entities.PartitionEntity;
import org.apache.inlong.audit.service.utils.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionManager.class);
    private static volatile PartitionManager partitionManager = null;
    private final ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();
    private DataSource dataSource;
    private final PartitionEntity auditDayTable;
    private final PartitionEntity auditTempTable;
    private final Configuration configuration = Configuration.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PartitionManager getInstance() {
        if (partitionManager != null) return partitionManager;
        Class<PartitionManager> clazz = PartitionManager.class;
        synchronized (PartitionManager.class) {
            if (partitionManager != null) return partitionManager;
            partitionManager = new PartitionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return partitionManager;
        }
    }

    private PartitionManager() {
        this.createDataSource();
        this.auditDayTable = this.createAndAddPartition("audit_data_day", "audit.data.day.add.partition.sql", "ALTER TABLE audit_data_day ADD PARTITION (PARTITION %s VALUES LESS THAN (TO_DAYS('%s')))", null, null);
        this.auditTempTable = this.createAndAddPartition("audit_data_temp", "audit.data.temp.add.partition.sql", "ALTER TABLE audit_data_temp ADD PARTITION (PARTITION %s VALUES LESS THAN (TO_DAYS('%s')))", "audit.data.temp.delete.partition.sql", "ALTER TABLE audit_data_temp DROP PARTITION %s");
    }

    private PartitionEntity createAndAddPartition(String tableName, String addPartitionKey, String defaultAddPartitionSql, String deletePartitionKey, String defaultDeletePartitionSql) {
        String addPartitionSql = this.configuration.get(addPartitionKey, defaultAddPartitionSql);
        String deletePartitionSql = deletePartitionKey != null ? this.configuration.get(deletePartitionKey, defaultDeletePartitionSql) : null;
        PartitionEntity partitionEntity = new PartitionEntity(tableName, addPartitionSql, deletePartitionSql);
        this.addPartition(partitionEntity, 0L);
        return partitionEntity;
    }

    public void start() {
        long intervalHours = this.configuration.get("check.partition.interval.hours", 6);
        this.timer.scheduleWithFixedDelay(() -> this.executePartitionManagement(), 0L, intervalHours, TimeUnit.HOURS);
    }

    private void executePartitionManagement() {
        try {
            this.managePartition(this.auditDayTable, false);
            this.managePartition(this.auditTempTable, true);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while managing partitions", (Throwable)e);
        }
    }

    private void managePartition(PartitionEntity partitionEntity, boolean delete) {
        this.addPartition(partitionEntity, 1L);
        if (delete) {
            long storageDays = this.configuration.get("audit.data.temp.storage.days", 3);
            this.deletePartition(partitionEntity, storageDays);
        }
    }

    private void addPartition(PartitionEntity partitionEntity, long daysToAdd) {
        String partitionName = partitionEntity.getAddPartitionName(daysToAdd);
        if (this.isPartitionExist(partitionEntity.getCheckPartitionSql(daysToAdd, false))) {
            LOGGER.info("Partition [{}] of [{}] already exists. Don`t need to add.", (Object)partitionName, (Object)partitionEntity.getTableName());
            return;
        }
        this.executeUpdate(partitionEntity.getAddPartitionSql(daysToAdd));
    }

    private void deletePartition(PartitionEntity partitionEntity, long daysToDelete) {
        String partitionName = partitionEntity.getDeletePartitionName(daysToDelete);
        if (!this.isPartitionExist(partitionEntity.getCheckPartitionSql(daysToDelete, true))) {
            LOGGER.info("Partition [{}] of [{}] does not exist. Don`t need to delete.", (Object)partitionName, (Object)partitionEntity.getTableName());
            return;
        }
        this.executeUpdate(partitionEntity.getDeletePartitionSql(daysToDelete));
    }

    /*
     * Exception decompiling
     */
    private boolean isPartitionExist(String querySql) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isPartitionInResultSet(PreparedStatement statement) {
        try (ResultSet resultSet = statement.executeQuery();){
            if (!resultSet.next()) return false;
            boolean bl = resultSet.getInt("count") > 0;
            return bl;
        }
        catch (SQLException sqlException) {
            LOGGER.error("An error occurred while processing the result set:", (Throwable)sqlException);
        }
        return false;
    }

    private void executeUpdate(String sql) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.executeUpdate();
            LOGGER.info("Success to manage partition, execute SQL: {}", (Object)sql);
        }
        catch (SQLException e) {
            LOGGER.error("Failed to execute update: {}", (Object)sql, (Object)e);
        }
    }

    private void createDataSource() {
        JdbcConfig jdbcConfig = JdbcUtils.buildMysqlConfig();
        HikariConfig hikariConfig = JdbcUtils.buildHikariConfig((String)jdbcConfig.getDriverClass(), (String)jdbcConfig.getJdbcUrl(), (String)jdbcConfig.getUserName(), (String)jdbcConfig.getPassword());
        this.dataSource = new HikariDataSource(hikariConfig);
    }
}

