/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.selector.impl;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.inlong.audit.service.selector.api.SelectorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBDataSource.class);
    private String selectorSql = "insert ignore into {0} (service_id, leader_id, last_seen_active) values (''{1}'', ''{2}'', now()) on duplicate key update leader_id = if(last_seen_active < now() - interval # second, values(leader_id), leader_id),last_seen_active = if(leader_id = values(leader_id), values(last_seen_active), last_seen_active)";
    private String replaceLeaderSql = "replace into {0} ( service_id, leader_id, last_seen_active ) values (''{1}'', ''#'', now())";
    private String reLeaseSql = "delete from {0} where service_id=''{1}'' and leader_id= ''{2}''";
    private String isLeaderSql = "select count(*) as is_leader from {0} where service_id=''{1}'' and leader_id=''{2}''";
    private String searchCurrentLeaderSql = "select leader_id as leader from {0} where service_id=''{1}''";
    private final SelectorConfig selectorConfig;
    private HikariDataSource datasource;
    public AtomicInteger getConnectionFailTimes;

    public DBDataSource(SelectorConfig selectorConfig) {
        this.selectorConfig = selectorConfig;
        this.getConnectionFailTimes = new AtomicInteger(0);
    }

    public void init(boolean needFormatSql) throws Exception {
        try {
            if (!this.selectorConfig.isUseDefaultLeader()) {
                this.initDataSource();
                if (needFormatSql) {
                    this.formatSql(new String[]{this.selectorConfig.getSelectorDbName(), this.selectorConfig.getServiceId(), this.selectorConfig.getLeaderId()});
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error(exception.getMessage());
            throw exception;
        }
    }

    public void initDataSource() throws Exception {
        boolean initSucc = false;
        int initCount = 0;
        while (!initSucc && initCount < 2) {
            try {
                ++initCount;
                if (this.datasource == null || this.datasource.isClosed()) {
                    HikariConfig config = new HikariConfig();
                    config.setDriverClassName(this.selectorConfig.getDbDriver());
                    LOGGER.info("Init dataSource:{}", (Object)this.selectorConfig.getDbUrl());
                    config.setJdbcUrl(this.selectorConfig.getDbUrl());
                    config.setUsername(this.selectorConfig.getDbUser());
                    config.setPassword(this.selectorConfig.getDbPasswd());
                    config.setMaximumPoolSize(this.selectorConfig.getMaximumPoolSize());
                    config.setAutoCommit(true);
                    config.setConnectionTimeout((long)this.selectorConfig.getConnectionTimeout());
                    config.setMaxLifetime((long)this.selectorConfig.getMaxLifetime());
                    config.addDataSourceProperty("cachePrepStmts", (Object)this.selectorConfig.getCachePrepStmts());
                    config.addDataSourceProperty("prepStmtCacheSize", (Object)this.selectorConfig.getPrepStmtCacheSize());
                    config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)this.selectorConfig.getPrepStmtCacheSqlLimit());
                    config.setConnectionTestQuery("SELECT 1 ");
                    this.datasource = new HikariDataSource(config);
                }
                initSucc = true;
            }
            catch (Exception exception) {
                LOGGER.error("DB url:{},user name:{},password:{},exception:{}", new Object[]{this.selectorConfig.getDbUrl(), this.selectorConfig.getDbUser(), this.selectorConfig.getDbPasswd(), exception.getMessage()});
            }
        }
        if (!initSucc) {
            throw new Exception("## DBDataSource init Fail\uff01");
        }
    }

    public void close() {
        this.datasource.close();
    }

    private int executeUpdate(String sql) {
        int result = 0;
        try {
            if (null == this.datasource || this.datasource.isClosed()) {
                this.initDataSource();
            }
            try (Connection connection = this.datasource.getConnection();){
                try (PreparedStatement pstmt = connection.prepareStatement(sql);){
                    result = pstmt.executeUpdate();
                }
                catch (Exception executeUpdatEexception) {
                    LOGGER.error("Exception :{}", (Object)executeUpdatEexception.getMessage());
                }
            }
            catch (Exception pstmtEexception) {
                LOGGER.error("Exception :{}", (Object)pstmtEexception.getMessage());
            }
            this.getConnectionFailTimes.set(0);
        }
        catch (Exception exception) {
            this.getConnectionFailTimes.addAndGet(1);
            LOGGER.warn("Get Connection fail. {}", (Object)exception.getMessage());
        }
        return result;
    }

    public void leaderSelector() {
        if (!this.selectorConfig.isUseDefaultLeader()) {
            try {
                int result = this.executeUpdate(this.selectorSql);
                if (result == 2) {
                    LOGGER.info("{} become the leader", (Object)this.selectorConfig.getLeaderId());
                } else if (result == 1) {
                    LOGGER.info("{} waiting to be the leader", (Object)this.selectorConfig.getLeaderId());
                }
            }
            catch (Exception exception) {
                LOGGER.error("Exception: {} ,sql:{}", (Object)exception.getMessage(), (Object)this.selectorSql);
            }
        }
    }

    public void replaceLeader(String replaceLeaderId) {
        this.replaceLeaderSql = this.replaceLeaderSql.replaceAll("#", replaceLeaderId);
        try {
            int result = this.executeUpdate(this.replaceLeaderSql);
            if (result > 0) {
                LOGGER.info("Replace leader success.sql:{}", (Object)this.replaceLeaderSql);
            } else {
                LOGGER.warn("Replace leader failed. sql:" + this.replaceLeaderSql);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Exception :{} ", (Object)exception.getMessage());
        }
    }

    public void releaseLeader() {
        try {
            int result = this.executeUpdate(this.reLeaseSql);
            LOGGER.info("ReleaseLeader sql:{}", (Object)this.reLeaseSql);
            if (result == 1) {
                LOGGER.info("{} release the leader success", (Object)this.selectorConfig.getLeaderId());
            }
        }
        catch (Exception exception) {
            LOGGER.error("ReLease sql:{},exception {}:,", (Object)this.reLeaseSql, (Object)exception.getMessage());
        }
    }

    public String getCurrentLeader() {
        if (this.selectorConfig.isUseDefaultLeader()) {
            return this.selectorConfig.getDefaultLeaderId();
        }
        String leaderId = "";
        try {
            if (null == this.datasource || this.datasource.isClosed()) {
                LOGGER.warn("DataSource is closed init is again");
                this.initDataSource();
            }
            try (Connection connection = this.datasource.getConnection();){
                try (PreparedStatement pstmt = connection.prepareStatement(this.searchCurrentLeaderSql);){
                    ResultSet resultSet = pstmt.executeQuery();
                    if (resultSet.next()) {
                        leaderId = resultSet.getString("leader");
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Exception {}", (Object)exception.getMessage());
                }
            }
            catch (Throwable connectionException) {
                LOGGER.error("Exception {}", (Object)connectionException.getMessage());
            }
        }
        catch (Exception datasourceException) {
            LOGGER.error("Exception {}", (Object)datasourceException.getMessage());
        }
        return leaderId;
    }

    public boolean isDBDataSourceClosed() {
        if (this.datasource != null) {
            try {
                Connection con = this.datasource.getConnection();
                if (con != null) {
                    con.close();
                }
                return false;
            }
            catch (Exception exception) {
                LOGGER.error("Exception {}", (Object)exception.getMessage());
                return true;
            }
        }
        return true;
    }

    public void formatSql(String ... params) {
        this.selectorSql = MessageFormat.format(this.selectorSql, params);
        this.selectorSql = this.selectorSql.replaceAll("#", this.selectorConfig.getLeaderTimeout() + "");
        LOGGER.info(this.selectorSql);
        this.replaceLeaderSql = MessageFormat.format(this.replaceLeaderSql, params);
        LOGGER.info(this.replaceLeaderSql);
        this.reLeaseSql = MessageFormat.format(this.reLeaseSql, params);
        LOGGER.info("ReLeaseSql:{}", (Object)this.reLeaseSql);
        this.isLeaderSql = MessageFormat.format(this.isLeaderSql, params);
        LOGGER.info(this.isLeaderSql);
        this.searchCurrentLeaderSql = MessageFormat.format(this.searchCurrentLeaderSql, params);
        LOGGER.info(this.searchCurrentLeaderSql);
    }
}

