/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;

@Internal
public final class ConstraintArgumentTypeStrategy
implements ArgumentTypeStrategy {
    private final String constraintMessage;
    private final Function<List<DataType>, Boolean> evaluator;

    public ConstraintArgumentTypeStrategy(String constraintMessage, Function<List<DataType>, Boolean> evaluator) {
        this.constraintMessage = constraintMessage;
        this.evaluator = evaluator;
    }

    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        List<DataType> actualDataTypes = callContext.getArgumentDataTypes();
        if (this.evaluator.apply(actualDataTypes).booleanValue()) {
            return Optional.of(actualDataTypes.get(argumentPos));
        }
        if (throwOnFailure) {
            throw callContext.newValidationError(this.constraintMessage, actualDataTypes.toArray());
        }
        return Optional.empty();
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        return Signature.Argument.of("<CONSTRAINT>");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstraintArgumentTypeStrategy that = (ConstraintArgumentTypeStrategy)o;
        return this.constraintMessage.equals(that.constraintMessage) && this.evaluator.equals(that.evaluator);
    }

    public int hashCode() {
        return Objects.hash(this.constraintMessage, this.evaluator);
    }
}

