/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.metric.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.inlong.audit.file.ConfigManager;
import org.apache.inlong.audit.metric.AbstractMetric;
import org.apache.inlong.audit.metric.MetricDimension;
import org.apache.inlong.audit.metric.MetricItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyPrometheusMetric
extends Collector
implements AbstractMetric {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyPrometheusMetric.class);
    private static final String HELP_DESCRIPTION = "Audit Proxy metrics help description";
    private static final String AUDIT_PROXY_SERVER_NAME = "audit-proxy";
    private final MetricItem metricItem;
    private HTTPServer server;

    public ProxyPrometheusMetric(MetricItem metricItem) {
        this.metricItem = metricItem;
        try {
            this.server = new HTTPServer(ConfigManager.getInstance().getValue("audit.proxy.prometheus.port", 10082));
            this.register();
        }
        catch (IOException e) {
            LOGGER.error("Construct proxy prometheus metric has IOException", (Throwable)e);
        }
    }

    public List<Collector.MetricFamilySamples> collect() {
        List<Collector.MetricFamilySamples.Sample> samples = Arrays.asList(this.createSample(MetricDimension.RECEIVE_COUNT_SUCCESS, this.metricItem.getReceiveCountSuccess().doubleValue()), this.createSample(MetricDimension.RECEIVE_PACK_SUCCESS, this.metricItem.getReceivePackSuccess().doubleValue()), this.createSample(MetricDimension.RECEIVE_SIZE_SUCCESS, this.metricItem.getReceiveSizeSuccess().doubleValue()), this.createSample(MetricDimension.RECEIVE_COUNT_INVALID, this.metricItem.getReceiveCountInvalid().doubleValue()), this.createSample(MetricDimension.RECEIVE_COUNT_EXPIRED, this.metricItem.getReceiveCountExpired().doubleValue()), this.createSample(MetricDimension.SEND_COUNT_SUCCESS, this.metricItem.getSendCountSuccess().doubleValue()), this.createSample(MetricDimension.SEND_COUNT_FAILED, this.metricItem.getSendCountFailed().doubleValue()));
        Collector.MetricFamilySamples metricFamilySamples = new Collector.MetricFamilySamples(AUDIT_PROXY_SERVER_NAME, Collector.Type.GAUGE, HELP_DESCRIPTION, samples);
        return Collections.singletonList(metricFamilySamples);
    }

    private Collector.MetricFamilySamples.Sample createSample(MetricDimension key, double value) {
        return new Collector.MetricFamilySamples.Sample(AUDIT_PROXY_SERVER_NAME, Collections.singletonList("dimensionName"), Collections.singletonList(key.getKey()), value);
    }

    public void report() {
        if (this.metricItem != null) {
            LOGGER.info("Report proxy Prometheus metric: {}", (Object)this.metricItem);
        } else {
            LOGGER.warn("MetricItem is null, nothing to report.");
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.close();
        }
    }
}

