/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.OverWindow;
import org.apache.flink.table.delegation.ExpressionParser;
import org.apache.flink.table.expressions.Expression;

@PublicEvolving
public final class OverWindowPartitionedOrderedPreceding {
    private final List<Expression> partitionBy;
    private final Expression orderBy;
    private final Expression preceding;
    private Optional<Expression> optionalFollowing = Optional.empty();

    OverWindowPartitionedOrderedPreceding(List<Expression> partitionBy, Expression orderBy, Expression preceding) {
        this.partitionBy = partitionBy;
        this.orderBy = orderBy;
        this.preceding = preceding;
    }

    public OverWindow as(String alias) {
        return this.as(ExpressionParser.INSTANCE.parseExpression(alias));
    }

    public OverWindow as(Expression alias) {
        return new OverWindow(alias, this.partitionBy, this.orderBy, this.preceding, this.optionalFollowing);
    }

    @Deprecated
    public OverWindowPartitionedOrderedPreceding following(String following) {
        return this.following(ExpressionParser.INSTANCE.parseExpression(following));
    }

    public OverWindowPartitionedOrderedPreceding following(Expression following) {
        this.optionalFollowing = Optional.of(following);
        return this;
    }
}

