/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.conf;

import com.google.common.collect.ComparisonChain;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.conf.AbstractConfiguration;
import org.apache.inlong.agent.utils.file.FileUtils;
import org.apache.inlong.common.enums.InstanceStateEnum;
import org.apache.inlong.common.enums.TaskTypeEnum;
import org.apache.inlong.common.pojo.dataproxy.DataProxyTopicInfo;
import org.apache.inlong.common.pojo.dataproxy.MQClusterInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceProfile
extends AbstractConfiguration
implements Comparable<InstanceProfile> {
    public static final String FILE_INSTANCE = "org.apache.inlong.agent.plugin.instance.FileInstance";
    public static final String COS_INSTANCE = "org.apache.inlong.agent.plugin.instance.COSInstance";
    public static final String KAFKA_INSTANCE = "org.apache.inlong.agent.plugin.instance.KafkaInstance";
    public static final String MONGODB_INSTANCE = "org.apache.inlong.agent.plugin.instance.MongoDBInstance";
    public static final String MQTT_INSTANCE = "org.apache.inlong.agent.plugin.instance.MqttInstance";
    public static final String ORACLE_INSTANCE = "org.apache.inlong.agent.plugin.instance.OracleInstance";
    public static final String POSTGRES_INSTANCE = "org.apache.inlong.agent.plugin.instance.PostgreSQLInstance";
    public static final String PULSAR_INSTANCE = "org.apache.inlong.agent.plugin.instance.PulsarInstance";
    public static final String REDIS_INSTANCE = "org.apache.inlong.agent.plugin.instance.RedisInstance";
    public static final String SQLSERVER_INSTANCE = "org.apache.inlong.agent.plugin.instance.SQLServerInstance";
    public static final String SQL_INSTANCE = "org.apache.inlong.agent.plugin.instance.SQLInstance";
    public static final String FILE_SOURCE = "org.apache.inlong.agent.plugin.sources.LogFileSource";
    public static final String BINLOG_SOURCE = "org.apache.inlong.agent.plugin.sources.BinlogSource";
    public static final String KAFKA_SOURCE = "org.apache.inlong.agent.plugin.sources.KafkaSource";
    public static final String PULSAR_SOURCE = "org.apache.inlong.agent.plugin.sources.PulsarSource";
    public static final String POSTGRESQL_SOURCE = "org.apache.inlong.agent.plugin.sources.PostgreSQLSource";
    public static final String MONGO_SOURCE = "org.apache.inlong.agent.plugin.sources.MongoDBSource";
    public static final String ORACLE_SOURCE = "org.apache.inlong.agent.plugin.sources.OracleSource";
    public static final String REDIS_SOURCE = "org.apache.inlong.agent.plugin.sources.RedisSource";
    public static final String MQTT_SOURCE = "org.apache.inlong.agent.plugin.sources.MqttSource";
    public static final String SQLSERVER_SOURCE = "org.apache.inlong.agent.plugin.sources.SQLServerSource";
    public static final String COS_SOURCE = "org.apache.inlong.agent.plugin.sources.COSSource";
    public static final String SQL_SOURCE = "org.apache.inlong.agent.plugin.sources.SQLSource";
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceProfile.class);
    private static final Gson GSON = new Gson();

    public static InstanceProfile parseJsonStr(String jsonStr) {
        InstanceProfile conf = new InstanceProfile();
        conf.loadJsonStrResource(jsonStr);
        return conf;
    }

    public String toJsonStr() {
        return GSON.toJson(this.getConfigStorage());
    }

    public String getInstanceClass() {
        TaskTypeEnum taskType = TaskTypeEnum.getTaskType((int)this.getInt("task.taskType", TaskTypeEnum.FILE.getType()));
        return InstanceProfile.getInstanceClassByTaskType(taskType);
    }

    public static String getInstanceClassByTaskType(TaskTypeEnum taskType) {
        if (taskType == null) {
            return null;
        }
        switch (taskType) {
            case FILE: {
                return FILE_INSTANCE;
            }
            case KAFKA: {
                return KAFKA_INSTANCE;
            }
            case PULSAR: {
                return PULSAR_INSTANCE;
            }
            case POSTGRES: {
                return POSTGRES_INSTANCE;
            }
            case ORACLE: {
                return ORACLE_INSTANCE;
            }
            case SQLSERVER: {
                return SQLSERVER_INSTANCE;
            }
            case MONGODB: {
                return MONGODB_INSTANCE;
            }
            case REDIS: {
                return REDIS_INSTANCE;
            }
            case MQTT: {
                return MQTT_INSTANCE;
            }
            case COS: {
                return COS_INSTANCE;
            }
            case SQL: {
                return SQL_INSTANCE;
            }
        }
        LOGGER.error("invalid task type {}", (Object)taskType);
        return null;
    }

    public String getTaskId() {
        return this.get("task.id");
    }

    public String getInstanceId() {
        return this.get("instance.id");
    }

    public String getCycleUnit() {
        return this.get("task.cycleUnit");
    }

    public String getSourceClass() {
        TaskTypeEnum taskType = TaskTypeEnum.getTaskType((int)this.getInt("task.taskType", TaskTypeEnum.FILE.getType()));
        return InstanceProfile.getSourceClassByTaskType(taskType);
    }

    public static String getSourceClassByTaskType(TaskTypeEnum taskType) {
        if (taskType == null) {
            return null;
        }
        switch (taskType) {
            case BINLOG: {
                return BINLOG_SOURCE;
            }
            case FILE: {
                return FILE_SOURCE;
            }
            case KAFKA: {
                return KAFKA_SOURCE;
            }
            case PULSAR: {
                return PULSAR_SOURCE;
            }
            case POSTGRES: {
                return POSTGRESQL_SOURCE;
            }
            case ORACLE: {
                return ORACLE_SOURCE;
            }
            case SQLSERVER: {
                return SQLSERVER_SOURCE;
            }
            case MONGODB: {
                return MONGO_SOURCE;
            }
            case REDIS: {
                return REDIS_SOURCE;
            }
            case MQTT: {
                return MQTT_SOURCE;
            }
            case COS: {
                return COS_SOURCE;
            }
            case SQL: {
                return SQL_SOURCE;
            }
        }
        LOGGER.error("invalid task type {}", (Object)taskType);
        return null;
    }

    public String getSinkClass() {
        return this.get("task.sink");
    }

    public InstanceStateEnum getState() {
        int value = this.getInt("instance.state", InstanceStateEnum.DEFAULT.ordinal());
        return InstanceStateEnum.getTaskState((int)value);
    }

    public void setState(InstanceStateEnum state) {
        this.setInt("instance.state", state.ordinal());
    }

    public long getFileUpdateTime() {
        return this.getLong("fileUpdateTime", 0L);
    }

    public void setFileUpdateTime(long lastUpdateTime) {
        this.setLong("fileUpdateTime", lastUpdateTime);
    }

    public String getPredefineFields() {
        return this.get("task.predefinedFields", "");
    }

    public String getInlongGroupId() {
        return this.get("proxy.inlongGroupId", "default_inlong_group_id");
    }

    public String getInlongStreamId() {
        return this.get("proxy.inlongStreamId", "default_inlong_stream_id");
    }

    @Override
    public boolean allRequiredKeyExist() {
        return this.hasKey("fileUpdateTime");
    }

    public List<MQClusterInfo> getMqClusters() {
        List result = null;
        String mqClusterStr = this.get("task.mqClusters");
        if (StringUtils.isNotBlank((CharSequence)mqClusterStr)) {
            result = (List)GSON.fromJson(mqClusterStr, new TypeToken<List<MQClusterInfo>>(){}.getType());
        }
        return result;
    }

    public DataProxyTopicInfo getMqTopic() {
        DataProxyTopicInfo result = null;
        String topicStr = this.get("task.topicInfo");
        if (StringUtils.isNotBlank((CharSequence)topicStr)) {
            result = (DataProxyTopicInfo)GSON.fromJson(topicStr, DataProxyTopicInfo.class);
        }
        return result;
    }

    public void setCreateTime(Long time) {
        this.setLong("instance.createTime", time);
    }

    public Long getCreateTime() {
        return this.getLong("instance.createTime", 0L);
    }

    public void setModifyTime(Long time) {
        this.setLong("instance.modifyTime", time);
    }

    public Long getModifyTime() {
        return this.getLong("instance.modifyTime", 0L);
    }

    public void setInstanceId(String instanceId) {
        this.set("instance.id", instanceId);
    }

    public void setSourceDataTime(String dataTime) {
        this.set("source.dataTime", dataTime);
    }

    public String getSourceDataTime() {
        return this.get("source.dataTime");
    }

    public void setSinkDataTime(Long dataTime) {
        this.setLong("sink.dataTime", dataTime);
    }

    public Long getSinkDataTime() {
        return this.getLong("sink.dataTime", 0L);
    }

    @Override
    public int compareTo(InstanceProfile object) {
        int ret = ComparisonChain.start().compare((Comparable)((Object)this.getSourceDataTime()), (Comparable)((Object)object.getSourceDataTime())).compare(FileUtils.getFileCreationTime(this.getInstanceId()), FileUtils.getFileCreationTime(object.getInstanceId())).compare(FileUtils.getFileLastModifyTime(this.getInstanceId()), FileUtils.getFileLastModifyTime(object.getInstanceId())).result();
        return ret;
    }

    public boolean isRetry() {
        return this.getBoolean("task.retry", false);
    }
}

