/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.message.file;

import java.util.Map;
import org.apache.inlong.agent.message.file.OffsetAckInfo;
import org.apache.inlong.agent.plugin.Message;

public class ProxyMessage
implements Message {
    private static final String DEFAULT_INLONG_STREAM_ID = "__";
    private final byte[] body;
    private final Map<String, String> header;
    private final String inlongGroupId;
    private final String inlongStreamId;
    OffsetAckInfo ackInfo;

    public ProxyMessage(byte[] body, Map<String, String> header) {
        this.body = body;
        this.header = header;
        this.inlongGroupId = header.get("inlongGroupId");
        this.inlongStreamId = header.getOrDefault("inlongStreamId", DEFAULT_INLONG_STREAM_ID);
        this.ackInfo = new OffsetAckInfo(header.get("offset"), body.length, false);
    }

    public ProxyMessage(Message message) {
        this(message.getBody(), message.getHeader());
    }

    @Override
    public byte[] getBody() {
        return this.body;
    }

    public OffsetAckInfo getAckInfo() {
        return this.ackInfo;
    }

    @Override
    public Map<String, String> getHeader() {
        return this.header;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }
}

