/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.message.file;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.message.file.OffsetAckInfo;
import org.apache.inlong.agent.message.file.ProxyMessage;
import org.apache.inlong.agent.message.file.SenderMessage;
import org.apache.inlong.agent.utils.AgentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyMessageCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyMessageCache.class);
    private final String taskId;
    private final String instanceId;
    private final int maxPackSize;
    private final int maxQueueNumber;
    private final String groupId;
    private final ConcurrentHashMap<String, LinkedBlockingQueue<ProxyMessage>> messageQueueMap;
    private long lastPrintTime = 0L;
    private long dataTime;
    private boolean isRealTime = false;
    private Map<String, String> extraMap = new HashMap<String, String>();

    public ProxyMessageCache(InstanceProfile instanceProfile, String groupId, String streamId) {
        this.taskId = instanceProfile.getTaskId();
        this.instanceId = instanceProfile.getInstanceId();
        this.groupId = groupId;
        this.maxPackSize = instanceProfile.getInt("proxy.package.maxSize", 512000);
        this.maxQueueNumber = instanceProfile.getInt("proxy.group.queue.maxNumber", 10000);
        this.messageQueueMap = new ConcurrentHashMap();
        this.dataTime = instanceProfile.getSinkDataTime();
        this.extraMap.put("syncSend", "false");
        this.extraMap.putAll(AgentUtils.parseAddAttrToMap(instanceProfile.getPredefineFields()));
        this.extraMap.put("auditVersion", instanceProfile.get("task.auditVersion"));
        String cycleUnit = instanceProfile.get("task.cycleUnit");
        if (cycleUnit.equalsIgnoreCase("R")) {
            this.isRealTime = true;
        }
    }

    private boolean queueIsFull(LinkedBlockingQueue<ProxyMessage> messageQueue) {
        return messageQueue.size() >= this.maxQueueNumber - 1;
    }

    public boolean add(ProxyMessage message) {
        String streamId = message.getInlongStreamId();
        LinkedBlockingQueue<ProxyMessage> messageQueue = this.makeSureQueueExist(streamId);
        try {
            if (this.queueIsFull(messageQueue)) {
                this.printQueueFull();
                return false;
            }
            messageQueue.put(message);
            return true;
        }
        catch (Exception ex) {
            LOGGER.error("exception caught", (Throwable)ex);
            return false;
        }
    }

    private void printQueueFull() {
        if (AgentUtils.getCurrentTime() - this.lastPrintTime > TimeUnit.SECONDS.toMillis(1L)) {
            this.lastPrintTime = AgentUtils.getCurrentTime();
            LOGGER.warn("message queue is greater than {}, stop adding message, maybe proxy get stuck", (Object)this.maxQueueNumber);
        }
    }

    public ConcurrentHashMap<String, LinkedBlockingQueue<ProxyMessage>> getMessageQueueMap() {
        return this.messageQueueMap;
    }

    private LinkedBlockingQueue<ProxyMessage> makeSureQueueExist(String streamId) {
        LinkedBlockingQueue<ProxyMessage> messageQueue = this.messageQueueMap.get(streamId);
        if (messageQueue == null) {
            messageQueue = new LinkedBlockingQueue();
            this.messageQueueMap.put(streamId, messageQueue);
        }
        return messageQueue;
    }

    public SenderMessage fetchSenderMessage(String streamId, LinkedBlockingQueue<ProxyMessage> messageQueue) {
        ProxyMessage peekMessage;
        int peekMessageLength;
        int resultBatchSize = 0;
        ArrayList<byte[]> bodyList = new ArrayList<byte[]>();
        ArrayList<OffsetAckInfo> offsetList = new ArrayList<OffsetAckInfo>();
        while (!messageQueue.isEmpty() && resultBatchSize + (peekMessageLength = (peekMessage = messageQueue.peek()).getBody().length) <= this.maxPackSize) {
            ProxyMessage message = (ProxyMessage)messageQueue.remove();
            int bodySize = message.getBody().length;
            if (peekMessageLength > this.maxPackSize) {
                LOGGER.warn("message size is {}, greater than max pack size {}, drop it!", (Object)peekMessage.getBody().length, (Object)this.maxPackSize);
                messageQueue.remove();
                break;
            }
            resultBatchSize += bodySize;
            bodyList.add(message.getBody());
            offsetList.add(message.getAckInfo());
        }
        long auditTime = 0L;
        auditTime = this.isRealTime ? AgentUtils.getCurrentTime() : this.dataTime;
        if (!bodyList.isEmpty()) {
            SenderMessage senderMessage = new SenderMessage(this.taskId, this.instanceId, this.groupId, streamId, bodyList, auditTime, this.extraMap, offsetList);
            return senderMessage;
        }
        return null;
    }
}

