/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.fieldtype.strategy;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.fieldtype.FieldTypeMappingReader;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeMappingStrategy;
import org.springframework.stereotype.Service;

@Service
public abstract class DefaultFieldTypeStrategy
implements FieldTypeMappingStrategy {
    private static final String NULLABLE_PATTERN = "^NULLABLE\\((.*)\\)$";
    private static final Pattern PATTERN = Pattern.compile("^NULLABLE\\((.*)\\)$");
    protected FieldTypeMappingReader reader = null;

    @Override
    public String getSourceToSinkFieldTypeMapping(String sourceType) {
        if (this.reader == null) {
            return sourceType;
        }
        String dataType = StringUtils.substringBefore((String)sourceType, (String)"(").toUpperCase();
        return this.reader.getSourceToSinkFieldTypeMap().getOrDefault(dataType, sourceType.toUpperCase());
    }

    @Override
    public String getStreamToSinkFieldTypeMapping(String sourceType) {
        Matcher matcher;
        if (this.reader == null) {
            return sourceType;
        }
        if (StringUtils.isNotBlank((CharSequence)sourceType) && (matcher = PATTERN.matcher(sourceType.toUpperCase())).matches()) {
            sourceType = matcher.group(1);
        }
        String dataType = StringUtils.substringBefore((String)sourceType, (String)"(").toUpperCase();
        return this.reader.getStreamToSinkFieldTypeMap().getOrDefault(dataType, sourceType.toUpperCase());
    }
}

