/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.cluster.ClusterTagRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagResponse;

@ApiModel(value="Inlong cluster tag ext param info")
public class InlongClusterTagExtParam
implements Serializable {
    private static final Gson GSON = new Gson();
    @ApiModelProperty(value="The compression type used for dataproxy and sort side data transmission to reduce the network IO overhead")
    private String inlongCompressType = "NONE";

    public static String packExtParams(ClusterTagRequest request) {
        InlongClusterTagExtParam extParam = (InlongClusterTagExtParam)CommonBeanUtils.copyProperties((Object)request, InlongClusterTagExtParam::new, (boolean)true);
        JsonObject obj = (JsonObject)GSON.fromJson(JsonUtils.toJsonString((Object)extParam), JsonObject.class);
        if (StringUtils.isBlank((CharSequence)request.getExtParams())) {
            return obj.toString();
        }
        JsonObject existObj = (JsonObject)GSON.fromJson(request.getExtParams(), JsonObject.class);
        for (String key : obj.keySet()) {
            JsonElement child = obj.get(key);
            if (child.isJsonNull()) continue;
            if (child.isJsonPrimitive()) {
                JsonPrimitive jsonPrimitive = child.getAsJsonPrimitive();
                if (jsonPrimitive.isBoolean()) {
                    existObj.addProperty(key, Boolean.valueOf(child.getAsBoolean()));
                    continue;
                }
                if (jsonPrimitive.isNumber()) {
                    existObj.addProperty(key, (Number)child.getAsInt());
                    continue;
                }
                existObj.addProperty(key, child.getAsString());
                continue;
            }
            existObj.addProperty(key, child.toString());
        }
        return existObj.toString();
    }

    public static void unpackExtParams(String extParams, Object targetObject) {
        InlongClusterTagExtParam inlongClusterTagExtParam;
        if (StringUtils.isNotBlank((CharSequence)extParams) && (inlongClusterTagExtParam = (InlongClusterTagExtParam)JsonUtils.parseObject((String)extParams, InlongClusterTagExtParam.class)) != null) {
            CommonBeanUtils.copyProperties((Object)inlongClusterTagExtParam, (Object)targetObject, (boolean)true);
        }
    }

    public static void unpackExtParams(ClusterTagResponse clusterTagResponse) {
        InlongClusterTagExtParam.unpackExtParams(clusterTagResponse.getExtParams(), clusterTagResponse);
    }

    public static InlongClusterTagExtParamBuilder builder() {
        return new InlongClusterTagExtParamBuilder();
    }

    public String getInlongCompressType() {
        return this.inlongCompressType;
    }

    public void setInlongCompressType(String inlongCompressType) {
        this.inlongCompressType = inlongCompressType;
    }

    public String toString() {
        return "InlongClusterTagExtParam(inlongCompressType=" + this.getInlongCompressType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongClusterTagExtParam)) {
            return false;
        }
        InlongClusterTagExtParam other = (InlongClusterTagExtParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$inlongCompressType = this.getInlongCompressType();
        String other$inlongCompressType = other.getInlongCompressType();
        return !(this$inlongCompressType == null ? other$inlongCompressType != null : !this$inlongCompressType.equals(other$inlongCompressType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlongClusterTagExtParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $inlongCompressType = this.getInlongCompressType();
        result = result * 59 + ($inlongCompressType == null ? 43 : $inlongCompressType.hashCode());
        return result;
    }

    public InlongClusterTagExtParam() {
    }

    public InlongClusterTagExtParam(String inlongCompressType) {
        this.inlongCompressType = inlongCompressType;
    }

    public static class InlongClusterTagExtParamBuilder {
        private String inlongCompressType;

        InlongClusterTagExtParamBuilder() {
        }

        public InlongClusterTagExtParamBuilder inlongCompressType(String inlongCompressType) {
            this.inlongCompressType = inlongCompressType;
            return this;
        }

        public InlongClusterTagExtParam build() {
            return new InlongClusterTagExtParam(this.inlongCompressType);
        }

        public String toString() {
            return "InlongClusterTagExtParam.InlongClusterTagExtParamBuilder(inlongCompressType=" + this.inlongCompressType + ")";
        }
    }
}

