/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.doris;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sink.doris.DorisSinkRequest;

@ApiModel(value="Doris sink info")
@JsonTypeDefine(value="DORIS")
public class DorisSink
extends StreamSink {
    @ApiModelProperty(value="Doris FE http address")
    private String feNodes;
    @ApiModelProperty(value="Username for doris accessing")
    private String username;
    @ApiModelProperty(value="Password for doris accessing")
    private String password;
    @ApiModelProperty(value="Doris table name, such as: db.tbl")
    private String tableIdentifier;
    @ApiModelProperty(value="Label prefix for stream loading. Used for guaranteeing Flink EOS semantics, as global unique is needed in 2pc.")
    private String labelPrefix;
    @ApiModelProperty(value="The primary key of sink table")
    private String primaryKey;
    @ApiModelProperty(value="The multiple enable of sink")
    private Boolean sinkMultipleEnable = false;
    @ApiModelProperty(value="The multiple format of sink")
    private String sinkMultipleFormat;
    @ApiModelProperty(value="The multiple database-pattern of sink")
    private String databasePattern;
    @ApiModelProperty(value="The multiple table-pattern of sink")
    private String tablePattern;

    public DorisSink() {
        this.setSinkType("DORIS");
    }

    @Override
    public SinkRequest genSinkRequest() {
        return (SinkRequest)CommonBeanUtils.copyProperties((Object)this, DorisSinkRequest::new);
    }

    protected DorisSink(DorisSinkBuilder<?, ?> b) {
        super((StreamSink.StreamSinkBuilder<?, ?>)b);
        this.feNodes = ((DorisSinkBuilder)b).feNodes;
        this.username = ((DorisSinkBuilder)b).username;
        this.password = ((DorisSinkBuilder)b).password;
        this.tableIdentifier = ((DorisSinkBuilder)b).tableIdentifier;
        this.labelPrefix = ((DorisSinkBuilder)b).labelPrefix;
        this.primaryKey = ((DorisSinkBuilder)b).primaryKey;
        this.sinkMultipleEnable = ((DorisSinkBuilder)b).sinkMultipleEnable;
        this.sinkMultipleFormat = ((DorisSinkBuilder)b).sinkMultipleFormat;
        this.databasePattern = ((DorisSinkBuilder)b).databasePattern;
        this.tablePattern = ((DorisSinkBuilder)b).tablePattern;
    }

    public static DorisSinkBuilder<?, ?> builder() {
        return new DorisSinkBuilderImpl();
    }

    public String getFeNodes() {
        return this.feNodes;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTableIdentifier() {
        return this.tableIdentifier;
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Boolean getSinkMultipleEnable() {
        return this.sinkMultipleEnable;
    }

    public String getSinkMultipleFormat() {
        return this.sinkMultipleFormat;
    }

    public String getDatabasePattern() {
        return this.databasePattern;
    }

    public String getTablePattern() {
        return this.tablePattern;
    }

    public void setFeNodes(String feNodes) {
        this.feNodes = feNodes;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTableIdentifier(String tableIdentifier) {
        this.tableIdentifier = tableIdentifier;
    }

    public void setLabelPrefix(String labelPrefix) {
        this.labelPrefix = labelPrefix;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setSinkMultipleEnable(Boolean sinkMultipleEnable) {
        this.sinkMultipleEnable = sinkMultipleEnable;
    }

    public void setSinkMultipleFormat(String sinkMultipleFormat) {
        this.sinkMultipleFormat = sinkMultipleFormat;
    }

    public void setDatabasePattern(String databasePattern) {
        this.databasePattern = databasePattern;
    }

    public void setTablePattern(String tablePattern) {
        this.tablePattern = tablePattern;
    }

    public DorisSink(String feNodes, String username, String password, String tableIdentifier, String labelPrefix, String primaryKey, Boolean sinkMultipleEnable, String sinkMultipleFormat, String databasePattern, String tablePattern) {
        this.feNodes = feNodes;
        this.username = username;
        this.password = password;
        this.tableIdentifier = tableIdentifier;
        this.labelPrefix = labelPrefix;
        this.primaryKey = primaryKey;
        this.sinkMultipleEnable = sinkMultipleEnable;
        this.sinkMultipleFormat = sinkMultipleFormat;
        this.databasePattern = databasePattern;
        this.tablePattern = tablePattern;
    }

    @Override
    public String toString() {
        return "DorisSink(super=" + super.toString() + ", feNodes=" + this.getFeNodes() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", tableIdentifier=" + this.getTableIdentifier() + ", labelPrefix=" + this.getLabelPrefix() + ", primaryKey=" + this.getPrimaryKey() + ", sinkMultipleEnable=" + this.getSinkMultipleEnable() + ", sinkMultipleFormat=" + this.getSinkMultipleFormat() + ", databasePattern=" + this.getDatabasePattern() + ", tablePattern=" + this.getTablePattern() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DorisSink)) {
            return false;
        }
        DorisSink other = (DorisSink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$sinkMultipleEnable = this.getSinkMultipleEnable();
        Boolean other$sinkMultipleEnable = other.getSinkMultipleEnable();
        if (this$sinkMultipleEnable == null ? other$sinkMultipleEnable != null : !((Object)this$sinkMultipleEnable).equals(other$sinkMultipleEnable)) {
            return false;
        }
        String this$feNodes = this.getFeNodes();
        String other$feNodes = other.getFeNodes();
        if (this$feNodes == null ? other$feNodes != null : !this$feNodes.equals(other$feNodes)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$tableIdentifier = this.getTableIdentifier();
        String other$tableIdentifier = other.getTableIdentifier();
        if (this$tableIdentifier == null ? other$tableIdentifier != null : !this$tableIdentifier.equals(other$tableIdentifier)) {
            return false;
        }
        String this$labelPrefix = this.getLabelPrefix();
        String other$labelPrefix = other.getLabelPrefix();
        if (this$labelPrefix == null ? other$labelPrefix != null : !this$labelPrefix.equals(other$labelPrefix)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$sinkMultipleFormat = this.getSinkMultipleFormat();
        String other$sinkMultipleFormat = other.getSinkMultipleFormat();
        if (this$sinkMultipleFormat == null ? other$sinkMultipleFormat != null : !this$sinkMultipleFormat.equals(other$sinkMultipleFormat)) {
            return false;
        }
        String this$databasePattern = this.getDatabasePattern();
        String other$databasePattern = other.getDatabasePattern();
        if (this$databasePattern == null ? other$databasePattern != null : !this$databasePattern.equals(other$databasePattern)) {
            return false;
        }
        String this$tablePattern = this.getTablePattern();
        String other$tablePattern = other.getTablePattern();
        return !(this$tablePattern == null ? other$tablePattern != null : !this$tablePattern.equals(other$tablePattern));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DorisSink;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $sinkMultipleEnable = this.getSinkMultipleEnable();
        result = result * 59 + ($sinkMultipleEnable == null ? 43 : ((Object)$sinkMultipleEnable).hashCode());
        String $feNodes = this.getFeNodes();
        result = result * 59 + ($feNodes == null ? 43 : $feNodes.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $tableIdentifier = this.getTableIdentifier();
        result = result * 59 + ($tableIdentifier == null ? 43 : $tableIdentifier.hashCode());
        String $labelPrefix = this.getLabelPrefix();
        result = result * 59 + ($labelPrefix == null ? 43 : $labelPrefix.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $sinkMultipleFormat = this.getSinkMultipleFormat();
        result = result * 59 + ($sinkMultipleFormat == null ? 43 : $sinkMultipleFormat.hashCode());
        String $databasePattern = this.getDatabasePattern();
        result = result * 59 + ($databasePattern == null ? 43 : $databasePattern.hashCode());
        String $tablePattern = this.getTablePattern();
        result = result * 59 + ($tablePattern == null ? 43 : $tablePattern.hashCode());
        return result;
    }

    private static final class DorisSinkBuilderImpl
    extends DorisSinkBuilder<DorisSink, DorisSinkBuilderImpl> {
        private DorisSinkBuilderImpl() {
        }

        @Override
        protected DorisSinkBuilderImpl self() {
            return this;
        }

        @Override
        public DorisSink build() {
            return new DorisSink(this);
        }
    }

    public static abstract class DorisSinkBuilder<C extends DorisSink, B extends DorisSinkBuilder<C, B>>
    extends StreamSink.StreamSinkBuilder<C, B> {
        private String feNodes;
        private String username;
        private String password;
        private String tableIdentifier;
        private String labelPrefix;
        private String primaryKey;
        private Boolean sinkMultipleEnable;
        private String sinkMultipleFormat;
        private String databasePattern;
        private String tablePattern;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B feNodes(String feNodes) {
            this.feNodes = feNodes;
            return (B)this.self();
        }

        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        public B tableIdentifier(String tableIdentifier) {
            this.tableIdentifier = tableIdentifier;
            return (B)this.self();
        }

        public B labelPrefix(String labelPrefix) {
            this.labelPrefix = labelPrefix;
            return (B)this.self();
        }

        public B primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return (B)this.self();
        }

        public B sinkMultipleEnable(Boolean sinkMultipleEnable) {
            this.sinkMultipleEnable = sinkMultipleEnable;
            return (B)this.self();
        }

        public B sinkMultipleFormat(String sinkMultipleFormat) {
            this.sinkMultipleFormat = sinkMultipleFormat;
            return (B)this.self();
        }

        public B databasePattern(String databasePattern) {
            this.databasePattern = databasePattern;
            return (B)this.self();
        }

        public B tablePattern(String tablePattern) {
            this.tablePattern = tablePattern;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DorisSink.DorisSinkBuilder(super=" + super.toString() + ", feNodes=" + this.feNodes + ", username=" + this.username + ", password=" + this.password + ", tableIdentifier=" + this.tableIdentifier + ", labelPrefix=" + this.labelPrefix + ", primaryKey=" + this.primaryKey + ", sinkMultipleEnable=" + this.sinkMultipleEnable + ", sinkMultipleFormat=" + this.sinkMultipleFormat + ", databasePattern=" + this.databasePattern + ", tablePattern=" + this.tablePattern + ")";
        }
    }
}

