/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.iceberg;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.Pattern;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.sink.SinkRequest;

@ApiModel(value="Iceberg sink request")
@JsonTypeDefine(value="ICEBERG")
public class IcebergSinkRequest
extends SinkRequest {
    @ApiModelProperty(value="Catalog type, like: HIVE, HADOOP, default is HIVE")
    private String catalogType = "HIVE";
    @ApiModelProperty(value="Catalog uri, such as hive metastore thrift://ip:port")
    private String catalogUri;
    @ApiModelProperty(value="Iceberg data warehouse dir")
    private String warehouse;
    @ApiModelProperty(value="Target database name")
    private String dbName;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Data path, such as: hdfs://ip:port/user/hive/warehouse/test.db")
    private String dataPath;
    @ApiModelProperty(value="File format, support: Parquet, Orc, Avro")
    private String fileFormat;
    @ApiModelProperty(value="Partition type, like: H-hour, D-day, W-week, M-month, O-once, R-regulation")
    private String partitionType;
    @ApiModelProperty(value="Primary key")
    private String primaryKey;
    @ApiModelProperty(value="append mode, UPSERT or APPEND")
    @Pattern(regexp="(?i)(UPSERT|APPEND)", message="Invalid append mode")
    private @Pattern(regexp="(?i)(UPSERT|APPEND)", message="Invalid append mode") String appendMode;
    @ApiModelProperty(value="The multiple enable of sink")
    private Boolean sinkMultipleEnable = false;
    @ApiModelProperty(value="The multiple format of sink")
    private String sinkMultipleFormat;
    @ApiModelProperty(value="database pattern")
    private String databasePattern;
    @ApiModelProperty(value="table pattern")
    private String tablePattern;
    @ApiModelProperty(value="enable schema change")
    private Boolean enableSchemaChange = false;

    public String getCatalogType() {
        return this.catalogType;
    }

    public String getCatalogUri() {
        return this.catalogUri;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public String getPartitionType() {
        return this.partitionType;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public String getAppendMode() {
        return this.appendMode;
    }

    public Boolean getSinkMultipleEnable() {
        return this.sinkMultipleEnable;
    }

    public String getSinkMultipleFormat() {
        return this.sinkMultipleFormat;
    }

    public String getDatabasePattern() {
        return this.databasePattern;
    }

    public String getTablePattern() {
        return this.tablePattern;
    }

    public Boolean getEnableSchemaChange() {
        return this.enableSchemaChange;
    }

    public void setCatalogType(String catalogType) {
        this.catalogType = catalogType;
    }

    public void setCatalogUri(String catalogUri) {
        this.catalogUri = catalogUri;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public void setPartitionType(String partitionType) {
        this.partitionType = partitionType;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setAppendMode(String appendMode) {
        this.appendMode = appendMode;
    }

    public void setSinkMultipleEnable(Boolean sinkMultipleEnable) {
        this.sinkMultipleEnable = sinkMultipleEnable;
    }

    public void setSinkMultipleFormat(String sinkMultipleFormat) {
        this.sinkMultipleFormat = sinkMultipleFormat;
    }

    public void setDatabasePattern(String databasePattern) {
        this.databasePattern = databasePattern;
    }

    public void setTablePattern(String tablePattern) {
        this.tablePattern = tablePattern;
    }

    public void setEnableSchemaChange(Boolean enableSchemaChange) {
        this.enableSchemaChange = enableSchemaChange;
    }

    @Override
    public String toString() {
        return "IcebergSinkRequest(super=" + super.toString() + ", catalogType=" + this.getCatalogType() + ", catalogUri=" + this.getCatalogUri() + ", warehouse=" + this.getWarehouse() + ", dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", dataPath=" + this.getDataPath() + ", fileFormat=" + this.getFileFormat() + ", partitionType=" + this.getPartitionType() + ", primaryKey=" + this.getPrimaryKey() + ", appendMode=" + this.getAppendMode() + ", sinkMultipleEnable=" + this.getSinkMultipleEnable() + ", sinkMultipleFormat=" + this.getSinkMultipleFormat() + ", databasePattern=" + this.getDatabasePattern() + ", tablePattern=" + this.getTablePattern() + ", enableSchemaChange=" + this.getEnableSchemaChange() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IcebergSinkRequest)) {
            return false;
        }
        IcebergSinkRequest other = (IcebergSinkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$sinkMultipleEnable = this.getSinkMultipleEnable();
        Boolean other$sinkMultipleEnable = other.getSinkMultipleEnable();
        if (this$sinkMultipleEnable == null ? other$sinkMultipleEnable != null : !((Object)this$sinkMultipleEnable).equals(other$sinkMultipleEnable)) {
            return false;
        }
        Boolean this$enableSchemaChange = this.getEnableSchemaChange();
        Boolean other$enableSchemaChange = other.getEnableSchemaChange();
        if (this$enableSchemaChange == null ? other$enableSchemaChange != null : !((Object)this$enableSchemaChange).equals(other$enableSchemaChange)) {
            return false;
        }
        String this$catalogType = this.getCatalogType();
        String other$catalogType = other.getCatalogType();
        if (this$catalogType == null ? other$catalogType != null : !this$catalogType.equals(other$catalogType)) {
            return false;
        }
        String this$catalogUri = this.getCatalogUri();
        String other$catalogUri = other.getCatalogUri();
        if (this$catalogUri == null ? other$catalogUri != null : !this$catalogUri.equals(other$catalogUri)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        if (this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$dataPath = this.getDataPath();
        String other$dataPath = other.getDataPath();
        if (this$dataPath == null ? other$dataPath != null : !this$dataPath.equals(other$dataPath)) {
            return false;
        }
        String this$fileFormat = this.getFileFormat();
        String other$fileFormat = other.getFileFormat();
        if (this$fileFormat == null ? other$fileFormat != null : !this$fileFormat.equals(other$fileFormat)) {
            return false;
        }
        String this$partitionType = this.getPartitionType();
        String other$partitionType = other.getPartitionType();
        if (this$partitionType == null ? other$partitionType != null : !this$partitionType.equals(other$partitionType)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$appendMode = this.getAppendMode();
        String other$appendMode = other.getAppendMode();
        if (this$appendMode == null ? other$appendMode != null : !this$appendMode.equals(other$appendMode)) {
            return false;
        }
        String this$sinkMultipleFormat = this.getSinkMultipleFormat();
        String other$sinkMultipleFormat = other.getSinkMultipleFormat();
        if (this$sinkMultipleFormat == null ? other$sinkMultipleFormat != null : !this$sinkMultipleFormat.equals(other$sinkMultipleFormat)) {
            return false;
        }
        String this$databasePattern = this.getDatabasePattern();
        String other$databasePattern = other.getDatabasePattern();
        if (this$databasePattern == null ? other$databasePattern != null : !this$databasePattern.equals(other$databasePattern)) {
            return false;
        }
        String this$tablePattern = this.getTablePattern();
        String other$tablePattern = other.getTablePattern();
        return !(this$tablePattern == null ? other$tablePattern != null : !this$tablePattern.equals(other$tablePattern));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IcebergSinkRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $sinkMultipleEnable = this.getSinkMultipleEnable();
        result = result * 59 + ($sinkMultipleEnable == null ? 43 : ((Object)$sinkMultipleEnable).hashCode());
        Boolean $enableSchemaChange = this.getEnableSchemaChange();
        result = result * 59 + ($enableSchemaChange == null ? 43 : ((Object)$enableSchemaChange).hashCode());
        String $catalogType = this.getCatalogType();
        result = result * 59 + ($catalogType == null ? 43 : $catalogType.hashCode());
        String $catalogUri = this.getCatalogUri();
        result = result * 59 + ($catalogUri == null ? 43 : $catalogUri.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $dataPath = this.getDataPath();
        result = result * 59 + ($dataPath == null ? 43 : $dataPath.hashCode());
        String $fileFormat = this.getFileFormat();
        result = result * 59 + ($fileFormat == null ? 43 : $fileFormat.hashCode());
        String $partitionType = this.getPartitionType();
        result = result * 59 + ($partitionType == null ? 43 : $partitionType.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $appendMode = this.getAppendMode();
        result = result * 59 + ($appendMode == null ? 43 : $appendMode.hashCode());
        String $sinkMultipleFormat = this.getSinkMultipleFormat();
        result = result * 59 + ($sinkMultipleFormat == null ? 43 : $sinkMultipleFormat.hashCode());
        String $databasePattern = this.getDatabasePattern();
        result = result * 59 + ($databasePattern == null ? 43 : $databasePattern.hashCode());
        String $tablePattern = this.getTablePattern();
        result = result * 59 + ($tablePattern == null ? 43 : $tablePattern.hashCode());
        return result;
    }
}

