/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.hudi;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.source.SourceRequest;

@ApiModel(value="Request of the Hudi source")
@JsonTypeDefine(value="HUDI")
public class HudiSourceRequest
extends SourceRequest {
    @ApiModelProperty(value="The database name of hudi")
    private String dbName;
    @ApiModelProperty(value="The table name of hudi")
    private String tableName;
    @ApiModelProperty(value="The catalog uri of hudi")
    private String catalogUri;
    @ApiModelProperty(value="The dfs base path of hudi")
    private String warehouse;
    @ApiModelProperty(value="The flag indicate whether skip files in compaction")
    private boolean readStreamingSkipCompaction;
    @ApiModelProperty(value="The start commit id")
    private String readStartCommit;
    @ApiModelProperty(value="Extended properties")
    private List<HashMap<String, String>> extList;

    public HudiSourceRequest() {
        this.setSourceType("HUDI");
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getCatalogUri() {
        return this.catalogUri;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public boolean isReadStreamingSkipCompaction() {
        return this.readStreamingSkipCompaction;
    }

    public String getReadStartCommit() {
        return this.readStartCommit;
    }

    public List<HashMap<String, String>> getExtList() {
        return this.extList;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setCatalogUri(String catalogUri) {
        this.catalogUri = catalogUri;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public void setReadStreamingSkipCompaction(boolean readStreamingSkipCompaction) {
        this.readStreamingSkipCompaction = readStreamingSkipCompaction;
    }

    public void setReadStartCommit(String readStartCommit) {
        this.readStartCommit = readStartCommit;
    }

    public void setExtList(List<HashMap<String, String>> extList) {
        this.extList = extList;
    }

    @Override
    public String toString() {
        return "HudiSourceRequest(super=" + super.toString() + ", dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", catalogUri=" + this.getCatalogUri() + ", warehouse=" + this.getWarehouse() + ", readStreamingSkipCompaction=" + this.isReadStreamingSkipCompaction() + ", readStartCommit=" + this.getReadStartCommit() + ", extList=" + this.getExtList() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HudiSourceRequest)) {
            return false;
        }
        HudiSourceRequest other = (HudiSourceRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isReadStreamingSkipCompaction() != other.isReadStreamingSkipCompaction()) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$catalogUri = this.getCatalogUri();
        String other$catalogUri = other.getCatalogUri();
        if (this$catalogUri == null ? other$catalogUri != null : !this$catalogUri.equals(other$catalogUri)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        if (this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse)) {
            return false;
        }
        String this$readStartCommit = this.getReadStartCommit();
        String other$readStartCommit = other.getReadStartCommit();
        if (this$readStartCommit == null ? other$readStartCommit != null : !this$readStartCommit.equals(other$readStartCommit)) {
            return false;
        }
        List<HashMap<String, String>> this$extList = this.getExtList();
        List<HashMap<String, String>> other$extList = other.getExtList();
        return !(this$extList == null ? other$extList != null : !((Object)this$extList).equals(other$extList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HudiSourceRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isReadStreamingSkipCompaction() ? 79 : 97);
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $catalogUri = this.getCatalogUri();
        result = result * 59 + ($catalogUri == null ? 43 : $catalogUri.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        String $readStartCommit = this.getReadStartCommit();
        result = result * 59 + ($readStartCommit == null ? 43 : $readStartCommit.hashCode());
        List<HashMap<String, String>> $extList = this.getExtList();
        result = result * 59 + ($extList == null ? 43 : ((Object)$extList).hashCode());
        return result;
    }
}

