/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.workflow.form.process;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.exceptions.FormValidateException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamBriefInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.BaseProcessForm;

public class ApplyGroupProcessForm
extends BaseProcessForm {
    public static final String FORM_NAME = "ApplyGroupProcessForm";
    @ApiModelProperty(value="Inlong group info")
    private InlongGroupInfo groupInfo;
    @ApiModelProperty(value="All inlong stream info under the inlong group, including the sink info")
    private List<InlongStreamBriefInfo> streamInfoList;
    @ApiModelProperty(value="Inlong group full info list")
    private List<GroupFullInfo> groupFullInfoList;

    @Override
    public void validate() throws FormValidateException {
        Preconditions.expectTrue((this.groupInfo != null || CollectionUtils.isNotEmpty(this.groupFullInfoList) ? 1 : 0) != 0, (String)"inlong group info is empty");
    }

    @Override
    public String getFormName() {
        return FORM_NAME;
    }

    @Override
    public String getInlongGroupId() {
        if (this.groupInfo != null) {
            return this.groupInfo.getInlongGroupId();
        }
        List groupIdList = this.groupFullInfoList.stream().map(v -> {
            InlongGroupInfo groupInfo = v.getGroupInfo();
            return groupInfo.getInlongGroupId();
        }).collect(Collectors.toList());
        return Joiner.on((String)",").join(groupIdList);
    }

    @Override
    public List<Map<String, Object>> showInList() {
        ArrayList<Map<String, Object>> showList = new ArrayList<Map<String, Object>>();
        if (this.groupInfo != null) {
            this.addShowInfo(this.groupInfo, showList);
        }
        if (CollectionUtils.isNotEmpty(this.groupFullInfoList)) {
            this.groupFullInfoList.forEach(groupFullInfo -> this.addShowInfo(groupFullInfo.getGroupInfo(), showList));
        }
        return showList;
    }

    private void addShowInfo(InlongGroupInfo groupInfo, List<Map<String, Object>> showList) {
        HashMap show = Maps.newHashMap();
        show.put("inlongGroupId", groupInfo.getInlongGroupId());
        show.put("inlongGroupMode", groupInfo.getInlongGroupMode());
        showList.add(show);
    }

    public InlongGroupInfo getGroupInfo() {
        return this.groupInfo;
    }

    public List<InlongStreamBriefInfo> getStreamInfoList() {
        return this.streamInfoList;
    }

    public List<GroupFullInfo> getGroupFullInfoList() {
        return this.groupFullInfoList;
    }

    public void setGroupInfo(InlongGroupInfo groupInfo) {
        this.groupInfo = groupInfo;
    }

    public void setStreamInfoList(List<InlongStreamBriefInfo> streamInfoList) {
        this.streamInfoList = streamInfoList;
    }

    public void setGroupFullInfoList(List<GroupFullInfo> groupFullInfoList) {
        this.groupFullInfoList = groupFullInfoList;
    }

    @Override
    public String toString() {
        return "ApplyGroupProcessForm(groupInfo=" + this.getGroupInfo() + ", streamInfoList=" + this.getStreamInfoList() + ", groupFullInfoList=" + this.getGroupFullInfoList() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplyGroupProcessForm)) {
            return false;
        }
        ApplyGroupProcessForm other = (ApplyGroupProcessForm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InlongGroupInfo this$groupInfo = this.getGroupInfo();
        InlongGroupInfo other$groupInfo = other.getGroupInfo();
        if (this$groupInfo == null ? other$groupInfo != null : !((Object)this$groupInfo).equals(other$groupInfo)) {
            return false;
        }
        List<InlongStreamBriefInfo> this$streamInfoList = this.getStreamInfoList();
        List<InlongStreamBriefInfo> other$streamInfoList = other.getStreamInfoList();
        if (this$streamInfoList == null ? other$streamInfoList != null : !((Object)this$streamInfoList).equals(other$streamInfoList)) {
            return false;
        }
        List<GroupFullInfo> this$groupFullInfoList = this.getGroupFullInfoList();
        List<GroupFullInfo> other$groupFullInfoList = other.getGroupFullInfoList();
        return !(this$groupFullInfoList == null ? other$groupFullInfoList != null : !((Object)this$groupFullInfoList).equals(other$groupFullInfoList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ApplyGroupProcessForm;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InlongGroupInfo $groupInfo = this.getGroupInfo();
        result = result * 59 + ($groupInfo == null ? 43 : ((Object)$groupInfo).hashCode());
        List<InlongStreamBriefInfo> $streamInfoList = this.getStreamInfoList();
        result = result * 59 + ($streamInfoList == null ? 43 : ((Object)$streamInfoList).hashCode());
        List<GroupFullInfo> $groupFullInfoList = this.getGroupFullInfoList();
        result = result * 59 + ($groupFullInfoList == null ? 43 : ((Object)$groupFullInfoList).hashCode());
        return result;
    }

    public static class GroupFullInfo {
        private InlongGroupInfo groupInfo;
        private List<InlongStreamBriefInfo> streamInfoList;

        public static GroupFullInfoBuilder builder() {
            return new GroupFullInfoBuilder();
        }

        public InlongGroupInfo getGroupInfo() {
            return this.groupInfo;
        }

        public List<InlongStreamBriefInfo> getStreamInfoList() {
            return this.streamInfoList;
        }

        public void setGroupInfo(InlongGroupInfo groupInfo) {
            this.groupInfo = groupInfo;
        }

        public void setStreamInfoList(List<InlongStreamBriefInfo> streamInfoList) {
            this.streamInfoList = streamInfoList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupFullInfo)) {
                return false;
            }
            GroupFullInfo other = (GroupFullInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            InlongGroupInfo this$groupInfo = this.getGroupInfo();
            InlongGroupInfo other$groupInfo = other.getGroupInfo();
            if (this$groupInfo == null ? other$groupInfo != null : !((Object)this$groupInfo).equals(other$groupInfo)) {
                return false;
            }
            List<InlongStreamBriefInfo> this$streamInfoList = this.getStreamInfoList();
            List<InlongStreamBriefInfo> other$streamInfoList = other.getStreamInfoList();
            return !(this$streamInfoList == null ? other$streamInfoList != null : !((Object)this$streamInfoList).equals(other$streamInfoList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GroupFullInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            InlongGroupInfo $groupInfo = this.getGroupInfo();
            result = result * 59 + ($groupInfo == null ? 43 : ((Object)$groupInfo).hashCode());
            List<InlongStreamBriefInfo> $streamInfoList = this.getStreamInfoList();
            result = result * 59 + ($streamInfoList == null ? 43 : ((Object)$streamInfoList).hashCode());
            return result;
        }

        public String toString() {
            return "ApplyGroupProcessForm.GroupFullInfo(groupInfo=" + this.getGroupInfo() + ", streamInfoList=" + this.getStreamInfoList() + ")";
        }

        public GroupFullInfo() {
        }

        public GroupFullInfo(InlongGroupInfo groupInfo, List<InlongStreamBriefInfo> streamInfoList) {
            this.groupInfo = groupInfo;
            this.streamInfoList = streamInfoList;
        }

        public static class GroupFullInfoBuilder {
            private InlongGroupInfo groupInfo;
            private List<InlongStreamBriefInfo> streamInfoList;

            GroupFullInfoBuilder() {
            }

            public GroupFullInfoBuilder groupInfo(InlongGroupInfo groupInfo) {
                this.groupInfo = groupInfo;
                return this;
            }

            public GroupFullInfoBuilder streamInfoList(List<InlongStreamBriefInfo> streamInfoList) {
                this.streamInfoList = streamInfoList;
                return this;
            }

            public GroupFullInfo build() {
                return new GroupFullInfo(this.groupInfo, this.streamInfoList);
            }

            public String toString() {
                return "ApplyGroupProcessForm.GroupFullInfo.GroupFullInfoBuilder(groupInfo=" + this.groupInfo + ", streamInfoList=" + this.streamInfoList + ")";
            }
        }
    }
}

