/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.util;

import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.kudu.shaded.com.google.common.base.Joiner;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.collect.ImmutableMap;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class SecurityUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtil.class);
    public static final String KUDU_TICKETCACHE_PROPERTY = "kudu.krb5ccname";
    private static final ImmutableMap<String, String> CERT_DIGEST_TO_MESSAGE_DIGEST = ImmutableMap.builder().put("MD5", "SHA-256").put("SHA1", "SHA-256").put("SHA224", "SHA-224").put("SHA256", "SHA-256").put("SHA384", "SHA-384").put("SHA512", "SHA-512").build();
    private static final long REFRESH_BEFORE_EXPIRATION_SECS = 10L;

    @Nullable
    public static Subject getSubjectFromTicketCacheOrNull() {
        Configuration conf = new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("useTicketCache", "true");
                options.put("doNotPrompt", "true");
                options.put("refreshKrb5Config", "true");
                options.put("debug", Boolean.toString(Boolean.getBoolean("kudu.jaas.debug")));
                String ticketCache = System.getProperty(SecurityUtil.KUDU_TICKETCACHE_PROPERTY, System.getenv("KRB5CCNAME"));
                if (ticketCache != null) {
                    LOG.debug("Using ticketCache: {}", (Object)ticketCache);
                    options.put("ticketCache", ticketCache);
                }
                options.put("renewTGT", "true");
                return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
            }
        };
        try {
            LoginContext loginContext = new LoginContext("kudu", new Subject(), null, conf);
            loginContext.login();
            Subject subject = loginContext.getSubject();
            LOG.debug("Logged in as subject: {}", (Object)Joiner.on(",").join(subject.getPrincipals()));
            return subject;
        }
        catch (LoginException e) {
            LOG.debug("Could not login via JAAS. Using no credentials: " + e.getMessage(), (Throwable)(LOG.isTraceEnabled() ? e : null));
            return null;
        }
    }

    public static byte[] getEndpointChannelBindings(Certificate cert) {
        Preconditions.checkArgument(cert instanceof X509Certificate, "can only handle X509 certs");
        X509Certificate x509 = (X509Certificate)cert;
        String sigAlg = x509.getSigAlgName();
        String sigAlgUpper = sigAlg.toUpperCase(Locale.ENGLISH);
        String[] components = sigAlgUpper.split("WITH", 2);
        String digestAlg = CERT_DIGEST_TO_MESSAGE_DIGEST.get(components[0]);
        if (digestAlg == null) {
            throw new RuntimeException("cert uses unknown signature algorithm: " + sigAlg);
        }
        try {
            return MessageDigest.getInstance(digestAlg).digest(cert.getEncoded());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean needsRefresh(Subject subject) {
        long deadline = System.currentTimeMillis() + 10000L;
        return SecurityUtil.tgtExpiresBefore(subject, deadline);
    }

    public static boolean isTgtExpired(Subject subject) {
        return SecurityUtil.tgtExpiresBefore(subject, System.currentTimeMillis());
    }

    private static boolean tgtExpiresBefore(Subject subject, long deadlineMillis) {
        KerberosTicket tgt = SecurityUtil.findTgt(subject);
        if (tgt != null) {
            return tgt.getEndTime().getTime() < deadlineMillis;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KerberosTicket findTgt(Subject subject) {
        Set<KerberosTicket> tickets;
        Set<KerberosTicket> set = tickets = subject.getPrivateCredentials(KerberosTicket.class);
        synchronized (set) {
            for (KerberosTicket ticket : tickets) {
                if (!SecurityUtil.isTGSPrincipal(ticket.getServer())) continue;
                return ticket;
            }
        }
        return null;
    }

    private static boolean isTGSPrincipal(KerberosPrincipal principal) {
        return principal != null && principal.getName().equals("krbtgt/" + principal.getRealm() + "@" + principal.getRealm());
    }

    public static KerberosPrincipal getKerberosPrincipalOrNull(Subject newSubject) {
        Set<KerberosPrincipal> principals = newSubject.getPrincipals(KerberosPrincipal.class);
        if (principals.size() > 1) {
            LOG.warn("JAAS Subject unexpectedly includes more than one principal: {}", (Object)Joiner.on(", ").join(principals));
            return null;
        }
        if (principals.isEmpty()) {
            return null;
        }
        return principals.iterator().next();
    }
}

