/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.network.tcp;

import org.apache.inlong.common.msg.MsgType;
import org.apache.inlong.dataproxy.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.inlong.dataproxy.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.inlong.sdk.dataproxy.network.tcp.TcpClientMgr;
import org.apache.inlong.sdk.dataproxy.network.tcp.codec.DecodeObject;
import org.apache.inlong.sdk.dataproxy.utils.LogCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHandler
extends SimpleChannelInboundHandler<DecodeObject> {
    private static final Logger logger = LoggerFactory.getLogger(ClientHandler.class);
    private static final LogCounter exceptCnt = new LogCounter(10L, 100000L, 60000L);
    private static final LogCounter thrownCnt = new LogCounter(10L, 100000L, 60000L);
    private final TcpClientMgr tcpClientMgr;

    public ClientHandler(TcpClientMgr tcpClientMgr) {
        this.tcpClientMgr = tcpClientMgr;
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, DecodeObject decObject) {
        if (decObject.getMsgType() != MsgType.MSG_BIN_HEARTBEAT) {
            this.tcpClientMgr.feedbackMsgResponse(ctx.channel().toString(), decObject);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        block3: {
            if (exceptCnt.shouldPrint()) {
                logger.warn("ClientHandler({})'s channel {} has error!", new Object[]{this.tcpClientMgr.getSenderId(), ctx.channel(), e});
            }
            try {
                this.tcpClientMgr.setChannelFrozen(ctx.channel().toString());
            }
            catch (Throwable ex) {
                if (!thrownCnt.shouldPrint()) break block3;
                logger.warn("ClientHandler({}) exceptionCaught throw exception", (Object)this.tcpClientMgr.getSenderId(), (Object)ex);
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        block3: {
            ctx.fireChannelInactive();
            if (logger.isDebugEnabled()) {
                logger.debug("ClientHandler({}) channelDisconnected {}", (Object)this.tcpClientMgr.getSenderId(), (Object)ctx.channel());
            }
            try {
                this.tcpClientMgr.notifyChannelDisconnected(ctx.channel().toString());
            }
            catch (Throwable ex) {
                if (!thrownCnt.shouldPrint()) break block3;
                logger.warn("ClientHandler({}) channelInactive throw exception", (Object)this.tcpClientMgr.getSenderId(), (Object)ex);
            }
        }
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        block3: {
            if (logger.isDebugEnabled()) {
                logger.debug("ClientHandler({}) channelUnregistered {}", (Object)this.tcpClientMgr.getSenderId(), (Object)ctx.channel());
            }
            try {
                this.tcpClientMgr.notifyChannelDisconnected(ctx.channel().toString());
            }
            catch (Throwable ex) {
                if (!thrownCnt.shouldPrint()) break block3;
                logger.warn("ClientHandler({}) channelUnregistered throw exception", (Object)this.tcpClientMgr.getSenderId(), (Object)ex);
            }
        }
    }
}

