/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.sender.tcp;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.ThreadFactory;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.inlong.common.msg.MsgType;
import org.apache.inlong.sdk.dataproxy.MsgSenderFactory;
import org.apache.inlong.sdk.dataproxy.common.ErrorCode;
import org.apache.inlong.sdk.dataproxy.common.ProcessResult;
import org.apache.inlong.sdk.dataproxy.common.SdkConsts;
import org.apache.inlong.sdk.dataproxy.config.EncryptConfigEntry;
import org.apache.inlong.sdk.dataproxy.network.tcp.SendQos;
import org.apache.inlong.sdk.dataproxy.network.tcp.TcpClientMgr;
import org.apache.inlong.sdk.dataproxy.network.tcp.TcpNettyClient;
import org.apache.inlong.sdk.dataproxy.network.tcp.codec.EncodeObject;
import org.apache.inlong.sdk.dataproxy.sender.BaseSender;
import org.apache.inlong.sdk.dataproxy.sender.MsgSendCallback;
import org.apache.inlong.sdk.dataproxy.sender.tcp.TcpEventInfo;
import org.apache.inlong.sdk.dataproxy.sender.tcp.TcpMsgSender;
import org.apache.inlong.sdk.dataproxy.sender.tcp.TcpMsgSenderConfig;
import org.apache.inlong.sdk.dataproxy.utils.LogCounter;
import org.apache.inlong.sdk.dataproxy.utils.ProxyUtils;
import org.xerial.snappy.Snappy;

public class InLongTcpMsgSender
extends BaseSender
implements TcpMsgSender {
    protected static final LogCounter tcpExceptCnt = new LogCounter(10L, 100000L, 60000L);
    private final TcpMsgSenderConfig tcpConfig;
    private final TcpClientMgr tcpClientMgr;

    public InLongTcpMsgSender(TcpMsgSenderConfig configure) {
        this(configure, null, null, null);
    }

    public InLongTcpMsgSender(TcpMsgSenderConfig configure, ThreadFactory selfDefineFactory) {
        this(configure, selfDefineFactory, null, null);
    }

    public InLongTcpMsgSender(TcpMsgSenderConfig configure, ThreadFactory selfDefineFactory, MsgSenderFactory senderFactory, String clusterIdKey) {
        super(configure, senderFactory, clusterIdKey);
        this.tcpConfig = (TcpMsgSenderConfig)this.baseConfig;
        this.clientMgr = new TcpClientMgr(this, this.tcpConfig, selfDefineFactory);
        this.tcpClientMgr = (TcpClientMgr)this.clientMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessage(TcpEventInfo eventInfo, ProcessResult procResult) {
        this.validParamsNotNull(eventInfo, procResult);
        if (!this.isStarted()) {
            return procResult.setFailResult(ErrorCode.SDK_CLOSED);
        }
        boolean gotPermits = false;
        long curTime = System.currentTimeMillis();
        try {
            if (!this.tryAcquireCachePermits(eventInfo.getBodySize(), procResult)) {
                boolean bl = false;
                return bl;
            }
            gotPermits = true;
            boolean bl = this.processEvent(SendQos.SOURCE_ACK, eventInfo, null, procResult);
            return bl;
        }
        finally {
            if (gotPermits) {
                this.releaseCachePermits(eventInfo.getBodySize());
            }
            if (procResult.isSuccess()) {
                this.metricHolder.addSyncSucMetric(eventInfo.getGroupId(), eventInfo.getStreamId(), eventInfo.getMsgCnt(), System.currentTimeMillis() - curTime);
            } else {
                this.metricHolder.addSyncFailMetric(procResult.getErrCode(), eventInfo.getGroupId(), eventInfo.getStreamId(), eventInfo.getMsgCnt());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean asyncSendMessage(TcpEventInfo eventInfo, MsgSendCallback callback, ProcessResult procResult) {
        this.validParamsNotNull(eventInfo, callback, procResult);
        if (!this.isStarted()) {
            return procResult.setFailResult(ErrorCode.SDK_CLOSED);
        }
        boolean gotPermits = false;
        try {
            if (!this.tryAcquireCachePermits(eventInfo.getBodySize(), procResult)) {
                boolean bl = false;
                return bl;
            }
            gotPermits = true;
            boolean bl = this.processEvent(SendQos.SOURCE_ACK, eventInfo, callback, procResult);
            return bl;
        }
        finally {
            if (procResult.isSuccess()) {
                this.metricHolder.addAsyncSucReqMetric(eventInfo.getGroupId(), eventInfo.getStreamId(), eventInfo.getMsgCnt());
            } else {
                if (gotPermits) {
                    this.releaseCachePermits(eventInfo.getBodySize());
                }
                this.metricHolder.addAsyncFailReqMetric(procResult.getErrCode(), eventInfo.getGroupId(), eventInfo.getStreamId(), eventInfo.getMsgCnt());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessageWithoutAck(TcpEventInfo eventInfo, ProcessResult procResult) {
        this.validParamsNotNull(eventInfo, procResult);
        if (!this.isStarted()) {
            return procResult.setFailResult(ErrorCode.SDK_CLOSED);
        }
        long curTime = System.currentTimeMillis();
        try {
            boolean bl = this.processEvent(SendQos.NO_ACK, eventInfo, null, procResult);
            return bl;
        }
        finally {
            if (procResult.isSuccess()) {
                this.metricHolder.addSyncSucMetric(eventInfo.getGroupId(), eventInfo.getStreamId(), eventInfo.getMsgCnt(), System.currentTimeMillis() - curTime);
            } else {
                this.metricHolder.addSyncFailMetric(procResult.getErrCode(), eventInfo.getGroupId(), eventInfo.getStreamId(), eventInfo.getMsgCnt());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMsgWithSinkAck(TcpEventInfo eventInfo, ProcessResult procResult) {
        this.validParamsNotNull(eventInfo, procResult);
        if (!this.isStarted()) {
            return procResult.setFailResult(ErrorCode.SDK_CLOSED);
        }
        boolean gotPermits = false;
        long curTime = System.currentTimeMillis();
        try {
            if (!this.tryAcquireCachePermits(eventInfo.getBodySize(), procResult)) {
                boolean bl = false;
                return bl;
            }
            gotPermits = true;
            boolean bl = this.processEvent(SendQos.SINK_ACK, eventInfo, null, procResult);
            return bl;
        }
        finally {
            if (gotPermits) {
                this.releaseCachePermits(eventInfo.getBodySize());
            }
            if (procResult.isSuccess()) {
                this.metricHolder.addSyncSucMetric(eventInfo.getGroupId(), eventInfo.getStreamId(), eventInfo.getMsgCnt(), System.currentTimeMillis() - curTime);
            } else {
                this.metricHolder.addSyncFailMetric(procResult.getErrCode(), eventInfo.getGroupId(), eventInfo.getStreamId(), eventInfo.getMsgCnt());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean asyncSendMsgWithSinkAck(TcpEventInfo eventInfo, MsgSendCallback callback, ProcessResult procResult) {
        this.validParamsNotNull(eventInfo, callback, procResult);
        if (!this.isStarted()) {
            return procResult.setFailResult(ErrorCode.SDK_CLOSED);
        }
        boolean gotPermits = false;
        try {
            if (!this.tryAcquireCachePermits(eventInfo.getBodySize(), procResult)) {
                boolean bl = false;
                return bl;
            }
            gotPermits = true;
            boolean bl = this.processEvent(SendQos.SINK_ACK, eventInfo, callback, procResult);
            return bl;
        }
        finally {
            if (procResult.isSuccess()) {
                this.metricHolder.addAsyncSucReqMetric(eventInfo.getGroupId(), eventInfo.getStreamId(), eventInfo.getMsgCnt());
            } else {
                if (gotPermits) {
                    this.releaseCachePermits(eventInfo.getBodySize());
                }
                this.metricHolder.addAsyncFailReqMetric(procResult.getErrCode(), eventInfo.getGroupId(), eventInfo.getStreamId(), eventInfo.getMsgCnt());
            }
        }
    }

    @Override
    public int getActiveNodeCnt() {
        return this.tcpClientMgr.getActiveNodeCnt();
    }

    @Override
    public int getInflightMsgCnt() {
        return this.tcpClientMgr.getInflightMsgCnt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processEvent(SendQos sendQos, TcpEventInfo eventInfo, MsgSendCallback callback, ProcessResult procResult) {
        if (this.isMetaInfoUnReady()) {
            return procResult.setFailResult(ErrorCode.NO_NODE_META_INFOS);
        }
        EncodeObject encObject = new EncodeObject(eventInfo.getGroupId(), eventInfo.getStreamId(), this.tcpConfig.getSdkMsgType(), eventInfo.getDtMs(), eventInfo.getBodySize());
        this.processEventAttrsInfo(sendQos, eventInfo, encObject);
        if (!this.isValidPkgLength(encObject.getAttrDataLength(), eventInfo.getBodySize(), this.getAllowedPkgLength(), procResult)) {
            return false;
        }
        if (!this.procEventBodyInfo(eventInfo, procResult, encObject)) {
            return false;
        }
        if (!this.tcpClientMgr.getClientByRoundRobin(procResult)) {
            return false;
        }
        TcpNettyClient client = (TcpNettyClient)procResult.getRetData();
        encObject.setMessageIdInfo(this.tcpClientMgr.getNextMsgId());
        try {
            boolean bl = this.tcpClientMgr.reportEvent(sendQos, client, encObject, callback, procResult);
            return bl;
        }
        finally {
            client.decClientUsingCnt();
        }
    }

    private boolean isValidPkgLength(int attrLength, int bodyLength, int allowedLen, ProcessResult procResult) {
        if (allowedLen < 0) {
            return true;
        }
        if (bodyLength + attrLength > allowedLen - SdkConsts.RESERVED_ATTRIBUTE_LENGTH) {
            String errMsg = String.format("OverMaxLen: attrLen(%d) + bodyLen(%d) > allowedLen(%d) - fixedLen(%d)", attrLength, bodyLength, allowedLen, SdkConsts.RESERVED_ATTRIBUTE_LENGTH);
            if (tcpExceptCnt.shouldPrint()) {
                logger.warn(errMsg);
            }
            return procResult.setFailResult(ErrorCode.REPORT_INFO_EXCEED_MAX_LEN, errMsg);
        }
        return true;
    }

    private void processEventAttrsInfo(SendQos sendQos, TcpEventInfo eventInfo, EncodeObject encodeObject) {
        int intMsgType = encodeObject.getMsgType().getValue();
        boolean enableDataComp = this.tcpConfig.isEnableDataCompress() && eventInfo.getBodySize() >= this.tcpConfig.getMinCompEnableLength();
        HashMap<String, String> newAttrs = new HashMap<String, String>(eventInfo.getAttrs());
        newAttrs.put("rtms", String.valueOf(encodeObject.getRtms()));
        newAttrs.put("sdkVersion", ProxyUtils.getJarVersion());
        if (sendQos == SendQos.NO_ACK) {
            newAttrs.put("isAck", String.valueOf(true));
        } else if (sendQos == SendQos.SINK_ACK) {
            newAttrs.put("proxySend", String.valueOf(true));
        }
        if (this.tcpConfig.getSdkMsgType() == MsgType.MSG_ACK_SERVICE || this.tcpConfig.getSdkMsgType() == MsgType.MSG_MULTI_BODY) {
            newAttrs.put("groupId", eventInfo.getGroupId());
            newAttrs.put("streamId", eventInfo.getStreamId());
            newAttrs.put("dt", String.valueOf(eventInfo.getDtMs()));
            newAttrs.put("cnt", String.valueOf(eventInfo.getMsgCnt()));
            if (enableDataComp) {
                newAttrs.put("cp", "snappy");
            }
        } else {
            if (enableDataComp) {
                intMsgType |= 0x20;
            }
            int extField = 0;
            if (this.tcpConfig.isSeparateEventByLF()) {
                extField |= 0x20;
            }
            boolean id2Num = false;
            int streamIdNum = 0;
            if (this.idTransNum && this.groupIdNum != 0 && eventInfo.getGroupId().equals(this.tcpConfig.getInlongGroupId())) {
                streamIdNum = this.getStreamIdNum(eventInfo.getStreamId());
                boolean bl = id2Num = streamIdNum != 0;
            }
            if (id2Num) {
                encodeObject.setGroupAndStreamId2Num(this.groupIdNum, streamIdNum);
            } else {
                extField |= 4;
                newAttrs.put("groupId", eventInfo.getGroupId());
                newAttrs.put("streamId", eventInfo.getStreamId());
            }
            encodeObject.setExtField(extField);
        }
        byte[] aesKey = null;
        if (this.tcpConfig.isEnableReportEncrypt()) {
            EncryptConfigEntry encryptEntry = this.configManager.getUserEncryptConfigEntry();
            newAttrs.put("_userName", this.tcpConfig.getRptUserName());
            newAttrs.put("_encyVersion", encryptEntry.getVersion());
            newAttrs.put("_encyAesKey", encryptEntry.getRsaEncryptedKey());
            aesKey = encryptEntry.getAesKey();
            intMsgType |= 0x40;
        }
        encodeObject.setAttrInfo(intMsgType, enableDataComp, aesKey, newAttrs);
    }

    private boolean procEventBodyInfo(TcpEventInfo eventInfo, ProcessResult procResult, EncodeObject encObject) {
        byte[] body = this.encBodyList(this.senderId, encObject.getMsgType(), this.tcpConfig.isSeparateEventByLF(), eventInfo, procResult);
        if (body == null) {
            return false;
        }
        if (encObject.isCompress() && (body = this.compressBodyInfo(this.senderId, body, procResult)) == null) {
            return false;
        }
        if (this.tcpConfig.isEnableReportEncrypt() && (body = this.aesEncryptBodyInfo(this.senderId, body, encObject.getAesKey(), procResult)) == null) {
            return false;
        }
        encObject.setBodyData(eventInfo.getMsgCnt(), body);
        return true;
    }

    private byte[] encBodyList(String senderId, MsgType msgType, boolean sepByLF, TcpEventInfo eventInfo, ProcessResult procResult) {
        try {
            int totalCnt = 0;
            ByteArrayOutputStream bodyOut = new ByteArrayOutputStream();
            if (msgType == MsgType.MSG_ACK_SERVICE) {
                for (byte[] entry : eventInfo.getBodyList()) {
                    if (totalCnt++ > 0) {
                        bodyOut.write("\n".getBytes(StandardCharsets.UTF_8));
                    }
                    bodyOut.write(entry);
                }
            } else if (msgType == MsgType.MSG_MULTI_BODY) {
                for (byte[] entry : eventInfo.getBodyList()) {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(4);
                    byteBuffer.putInt(entry.length);
                    bodyOut.write(byteBuffer.array());
                    bodyOut.write(entry);
                }
            } else if (sepByLF) {
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                for (byte[] entry : eventInfo.getBodyList()) {
                    if (totalCnt++ > 0) {
                        data.write("\n".getBytes(StandardCharsets.UTF_8));
                    }
                    data.write(entry);
                }
                ByteBuffer dataBuffer = ByteBuffer.allocate(4);
                dataBuffer.putInt(data.toByteArray().length);
                bodyOut.write(dataBuffer.array());
                bodyOut.write(data.toByteArray());
            } else {
                for (byte[] entry : eventInfo.getBodyList()) {
                    ByteBuffer dataBuffer = ByteBuffer.allocate(4);
                    dataBuffer.putInt(entry.length);
                    bodyOut.write(dataBuffer.array());
                    bodyOut.write(entry);
                }
            }
            return bodyOut.toByteArray();
        }
        catch (Throwable ex) {
            procResult.setFailResult(ErrorCode.ENCODE_BODY_EXCEPTION, ex.getMessage());
            if (tcpExceptCnt.shouldPrint()) {
                logger.warn("Sender({}) encode body exception", (Object)senderId, (Object)ex);
            }
            return null;
        }
    }

    private byte[] compressBodyInfo(String senderId, byte[] body, ProcessResult procResult) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(body);
            int guessLen = Snappy.maxCompressedLength((int)out.size());
            byte[] tmpData = new byte[guessLen];
            int len = Snappy.compress((byte[])out.toByteArray(), (int)0, (int)out.size(), (byte[])tmpData, (int)0);
            body = new byte[len];
            System.arraycopy(tmpData, 0, body, 0, len);
            return body;
        }
        catch (Throwable ex) {
            procResult.setFailResult(ErrorCode.COMPRESS_BODY_EXCEPTION, ex.getMessage());
            if (tcpExceptCnt.shouldPrint()) {
                logger.warn("Sender({}) compress body exception", (Object)senderId, (Object)ex);
            }
            return null;
        }
    }

    private byte[] aesEncryptBodyInfo(String senderId, byte[] plainText, byte[] aesKey, ProcessResult procResult) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(aesKey, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKeySpec);
            return cipher.doFinal(plainText);
        }
        catch (Throwable ex) {
            procResult.setFailResult(ErrorCode.ENCRYPT_BODY_EXCEPTION, ex.getMessage());
            if (tcpExceptCnt.shouldPrint()) {
                logger.warn("Sender({}) aesEncrypt body exception", (Object)senderId, (Object)ex);
            }
            return null;
        }
    }

    private void validParamsNotNull(TcpEventInfo eventInfo, ProcessResult procResult) {
        if (eventInfo == null) {
            throw new NullPointerException("eventInfo is null");
        }
        if (procResult == null) {
            throw new NullPointerException("procResult is null");
        }
    }

    private void validParamsNotNull(TcpEventInfo eventInfo, MsgSendCallback callback, ProcessResult procResult) {
        if (eventInfo == null) {
            throw new NullPointerException("eventInfo is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is null");
        }
        if (procResult == null) {
            throw new NullPointerException("procResult is null");
        }
    }
}

