/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.message;

import io.debezium.document.Document;
import io.debezium.document.DocumentWriter;
import io.debezium.relational.history.HistoryRecord;
import java.io.IOException;

public class SchemaRecord {
    private final HistoryRecord historyRecord;
    private final Document tableChangeDoc;

    public SchemaRecord(HistoryRecord historyRecord) {
        this.historyRecord = historyRecord;
        this.tableChangeDoc = null;
    }

    public SchemaRecord(Document document) {
        if (this.isHistoryRecordDocument(document)) {
            this.historyRecord = new HistoryRecord(document);
            this.tableChangeDoc = null;
        } else {
            this.tableChangeDoc = document;
            this.historyRecord = null;
        }
    }

    public HistoryRecord getHistoryRecord() {
        return this.historyRecord;
    }

    public Document getTableChangeDoc() {
        return this.tableChangeDoc;
    }

    public boolean isHistoryRecord() {
        return this.historyRecord != null;
    }

    public boolean isTableChangeRecord() {
        return this.tableChangeDoc != null;
    }

    public Document toDocument() {
        return this.historyRecord != null ? this.historyRecord.document() : this.tableChangeDoc;
    }

    public String toString() {
        try {
            return DocumentWriter.defaultWriter().write(this.toDocument());
        }
        catch (IOException var2) {
            return super.toString();
        }
    }

    private boolean isHistoryRecordDocument(Document document) {
        return new HistoryRecord(document).isValid();
    }
}

