/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.AbstractConsumeAllOperator;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.tsfile.utils.RamUsageEstimator;

public class ActiveRegionScanMergeOperator
extends AbstractConsumeAllOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(ActiveRegionScanMergeOperator.class) + RamUsageEstimator.shallowSizeOfInstance(Set.class);
    private static final long REFERENCE_SIZE = 8L;
    private final int[] inputIndex = new int[this.inputOperatorsCount];
    private final boolean[] noMoreTsBlocks = new boolean[this.inputOperatorsCount];
    private final TsBlockBuilder tsBlockBuilder;
    private final boolean outputCount;
    private final boolean needMergeBeforeCount;
    private boolean finished;
    private Set<String> deduplicatedSet;
    private long count = -1L;
    private long estimatedSetSize = 0L;

    public ActiveRegionScanMergeOperator(OperatorContext operatorContext, List<Operator> children, List<TSDataType> dataTypes, boolean outputCount, boolean needMergeBeforeCount, long estimatedSize) {
        super(operatorContext, children);
        this.tsBlockBuilder = new TsBlockBuilder(dataTypes);
        this.finished = false;
        this.outputCount = outputCount;
        this.needMergeBeforeCount = needMergeBeforeCount;
        if (!outputCount || needMergeBeforeCount) {
            this.deduplicatedSet = new HashSet<String>();
            this.estimatedSetSize = estimatedSize * 8L;
        }
        if (outputCount) {
            this.count = 0L;
        }
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        boolean hasReadyChild = false;
        ArrayList listenableFutures = new ArrayList();
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i] || !this.isEmpty(i) || this.children.get(i) == null) continue;
            ListenableFuture<?> blocked = ((Operator)this.children.get(i)).isBlocked();
            if (blocked.isDone()) {
                hasReadyChild = true;
                this.canCallNext[i] = true;
                continue;
            }
            listenableFutures.add(blocked);
        }
        return hasReadyChild || listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
    }

    @Override
    public TsBlock next() throws Exception {
        int i;
        if (!this.prepareInput()) {
            return null;
        }
        this.tsBlockBuilder.reset();
        int maxRowCanBuild = Integer.MAX_VALUE;
        for (i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.inputTsBlocks[i] == null) continue;
            maxRowCanBuild = Math.min(maxRowCanBuild, this.inputTsBlocks[i].getPositionCount() - this.inputIndex[i]);
        }
        if (!this.needMergeBeforeCount) {
            for (i = 0; i < this.inputOperatorsCount; ++i) {
                if (this.inputTsBlocks[i] == null) continue;
                for (int row = 0; row < maxRowCanBuild; ++row) {
                    long childCount = this.inputTsBlocks[i].getValueColumns()[0].getLong(this.inputIndex[i] + row);
                    this.count += childCount;
                    int n = i;
                    this.inputIndex[n] = this.inputIndex[n] + maxRowCanBuild;
                }
            }
        } else {
            TimeColumnBuilder timeColumnBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
            ColumnBuilder[] valueColumnBuilders = this.tsBlockBuilder.getValueColumnBuilders();
            for (int i2 = 0; i2 < this.inputOperatorsCount; ++i2) {
                if (this.inputTsBlocks[i2] == null) continue;
                int curTsBlockRowIndex = this.inputIndex[i2];
                for (int row = 0; row < maxRowCanBuild; ++row) {
                    String id = this.inputTsBlocks[i2].getValueColumns()[0].getBinary(curTsBlockRowIndex + row).toString();
                    if (this.deduplicatedSet.contains(id)) continue;
                    this.deduplicatedSet.add(id);
                    this.buildOneRow(i2, curTsBlockRowIndex + row, timeColumnBuilder, valueColumnBuilders);
                }
                int n = i2;
                this.inputIndex[n] = this.inputIndex[n] + maxRowCanBuild;
            }
        }
        return this.outputCount ? this.returnResultIfNoMoreData() : this.tsBlockBuilder.build();
    }

    @Override
    protected TsBlock getNextTsBlock(int childIndex) throws Exception {
        this.inputIndex[childIndex] = 0;
        return ((Operator)this.children.get(childIndex)).nextWithTimer();
    }

    @Override
    protected boolean canSkipCurrentChild(int currentChildIndex) {
        return this.noMoreTsBlocks[currentChildIndex] || !this.isEmpty(currentChildIndex) || this.children.get(currentChildIndex) == null;
    }

    @Override
    protected void handleFinishedChild(int currentChildIndex) throws Exception {
        this.noMoreTsBlocks[currentChildIndex] = true;
        this.inputTsBlocks[currentChildIndex] = null;
        ((Operator)this.children.get(currentChildIndex)).close();
        this.children.set(currentChildIndex, null);
    }

    private TsBlock returnResultIfNoMoreData() throws Exception {
        if (this.isFinished() || this.finished) {
            this.tsBlockBuilder.reset();
            TimeColumnBuilder timeColumnBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
            ColumnBuilder[] valueColumnBuilders = this.tsBlockBuilder.getValueColumnBuilders();
            timeColumnBuilder.writeLong(-1L);
            valueColumnBuilders[0].writeLong(this.count);
            this.tsBlockBuilder.declarePosition();
            this.count = -1L;
            return this.tsBlockBuilder.build();
        }
        return null;
    }

    private void buildOneRow(int i, int curTsBlockRowIndex, TimeColumnBuilder timeColumnBuilder, ColumnBuilder[] valueColumnBuilders) {
        if (this.outputCount) {
            ++this.count;
        } else {
            timeColumnBuilder.writeLong(-1L);
            for (int j = 0; j < valueColumnBuilders.length; ++j) {
                if (this.inputTsBlocks[i].getValueColumns()[j].isNull(curTsBlockRowIndex)) {
                    valueColumnBuilders[j].appendNull();
                    continue;
                }
                valueColumnBuilders[j].writeBinary(this.inputTsBlocks[i].getValueColumns()[j].getBinary(curTsBlockRowIndex));
            }
            this.tsBlockBuilder.declarePosition();
        }
    }

    @Override
    protected boolean isEmpty(int tsBlockIndex) {
        return this.inputTsBlocks[tsBlockIndex] == null || this.inputTsBlocks[tsBlockIndex].getPositionCount() == this.inputIndex[tsBlockIndex];
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.finished) {
            return false;
        }
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (!this.isEmpty(i)) {
                return true;
            }
            if (this.noMoreTsBlocks[i]) continue;
            if (!this.canCallNext[i] || this.children.get(i) != null && ((Operator)this.children.get(i)).hasNextWithTimer()) {
                return true;
            }
            this.noMoreTsBlocks[i] = true;
            this.inputTsBlocks[i] = null;
        }
        return this.count != -1L;
    }

    @Override
    public boolean isFinished() throws Exception {
        if (this.finished) {
            return true;
        }
        this.finished = true;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i] && this.isEmpty(i)) continue;
            this.finished = false;
            break;
        }
        return this.finished && this.count == -1L;
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = this.estimatedSetSize;
        long childrenMaxPeekMemory = 0L;
        for (Operator child : this.children) {
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, maxPeekMemory + child.calculateMaxPeekMemoryWithCounter());
            maxPeekMemory += child.calculateMaxReturnSize() + child.calculateRetainedSizeAfterCallingNext();
        }
        return Math.max(maxPeekMemory += this.calculateMaxReturnSize(), childrenMaxPeekMemory);
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long currentRetainedSize = 0L;
        long minChildReturnSize = Long.MAX_VALUE;
        for (Operator child : this.children) {
            long maxReturnSize = child.calculateMaxReturnSize();
            currentRetainedSize += maxReturnSize + child.calculateRetainedSizeAfterCallingNext();
            minChildReturnSize = Math.min(minChildReturnSize, maxReturnSize);
        }
        return currentRetainedSize - minChildReturnSize;
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.children.stream().mapToLong(MemoryEstimationHelper::getEstimatedSizeOfAccountableObject).sum() + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + RamUsageEstimator.sizeOf((boolean[])this.canCallNext) + RamUsageEstimator.sizeOf((boolean[])this.noMoreTsBlocks) + RamUsageEstimator.sizeOf((int[])this.inputIndex) + this.tsBlockBuilder.getRetainedSizeInBytes();
    }
}

