/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.literal;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.statement.literal.Literal;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class BooleanLiteral
extends Literal {
    private final boolean value;

    public BooleanLiteral(String value) {
        this.value = Boolean.parseBoolean(value);
    }

    public BooleanLiteral(boolean value) {
        this.value = value;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)Literal.LiteralType.BOOLEAN.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.value, (ByteBuffer)byteBuffer);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)Literal.LiteralType.BOOLEAN.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.value, (OutputStream)stream);
    }

    @Override
    public boolean isDataTypeConsistency(TSDataType dataType) {
        return dataType == TSDataType.BOOLEAN || dataType == TSDataType.TEXT || dataType == TSDataType.STRING;
    }

    @Override
    public String getDataTypeString() {
        return TSDataType.BOOLEAN.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanLiteral that = (BooleanLiteral)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public boolean getBoolean() {
        return this.value;
    }

    @Override
    public Binary getBinary() {
        return new Binary(String.valueOf(this.value), TSFileConfig.STRING_CHARSET);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

