/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.active;

import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.iotdb.db.storageengine.load.metrics.ActiveLoadingFilesNumberMetricsSet;
import org.apache.tsfile.utils.Pair;

public class ActiveLoadPendingQueue {
    private final Set<String> pendingFileSet = new HashSet<String>();
    private final Queue<Pair<String, Boolean>> pendingFileQueue = new ConcurrentLinkedQueue<Pair<String, Boolean>>();
    private final Set<String> loadingFileSet = new HashSet<String>();

    public synchronized boolean enqueue(String file, boolean isGeneratedByPipe) {
        if (!this.loadingFileSet.contains(file) && this.pendingFileSet.add(file)) {
            this.pendingFileQueue.offer((Pair<String, Boolean>)new Pair((Object)file, (Object)isGeneratedByPipe));
            ActiveLoadingFilesNumberMetricsSet.getInstance().increaseQueuingFileCounter(1L);
            return true;
        }
        return false;
    }

    public synchronized Pair<String, Boolean> dequeueFromPending() {
        Pair<String, Boolean> pair = this.pendingFileQueue.poll();
        if (pair != null) {
            this.pendingFileSet.remove(pair.left);
            this.loadingFileSet.add((String)pair.left);
            ActiveLoadingFilesNumberMetricsSet.getInstance().increaseLoadingFileCounter(1L);
            ActiveLoadingFilesNumberMetricsSet.getInstance().increaseQueuingFileCounter(-1L);
        }
        return pair;
    }

    public synchronized void removeFromLoading(String file) {
        this.loadingFileSet.remove(file);
        ActiveLoadingFilesNumberMetricsSet.getInstance().increaseLoadingFileCounter(-1L);
    }

    public synchronized boolean isFilePendingOrLoading(String file) {
        return this.loadingFileSet.contains(file) || this.pendingFileSet.contains(file);
    }

    public int size() {
        return this.pendingFileQueue.size() + this.loadingFileSet.size();
    }

    public boolean isEmpty() {
        return this.pendingFileQueue.isEmpty() && this.loadingFileSet.isEmpty();
    }
}

