/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.task.meta;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTemporaryMeta;

public class PipeTemporaryMetaInCoordinator
implements PipeTemporaryMeta {
    private final Set<Integer> completedDataNodeIds = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentMap<Integer, Long> nodeId2RemainingEventMap = new ConcurrentHashMap<Integer, Long>();
    private final ConcurrentMap<Integer, Double> nodeId2RemainingTimeMap = new ConcurrentHashMap<Integer, Double>();

    public void markDataNodeCompleted(int dataNodeId) {
        this.completedDataNodeIds.add(dataNodeId);
    }

    public void markDataNodeUncompleted(int dataNodeId) {
        this.completedDataNodeIds.remove(dataNodeId);
    }

    public void setRemainingEvent(int dataNodeId, long remainingEventCount) {
        this.nodeId2RemainingEventMap.put(dataNodeId, remainingEventCount);
    }

    public void setRemainingTime(int dataNodeId, double remainingTime) {
        this.nodeId2RemainingTimeMap.put(dataNodeId, remainingTime);
    }

    public Set<Integer> getCompletedDataNodeIds() {
        return this.completedDataNodeIds;
    }

    public long getGlobalRemainingEvents() {
        return this.nodeId2RemainingEventMap.values().stream().reduce(Long::sum).orElse(0L);
    }

    public double getGlobalRemainingTime() {
        return this.nodeId2RemainingTimeMap.values().stream().reduce(Math::max).orElse(0.0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipeTemporaryMetaInCoordinator that = (PipeTemporaryMetaInCoordinator)o;
        return Objects.equals(this.completedDataNodeIds, that.completedDataNodeIds) && Objects.equals(this.nodeId2RemainingEventMap, that.nodeId2RemainingEventMap) && Objects.equals(this.nodeId2RemainingTimeMap, that.nodeId2RemainingTimeMap);
    }

    public int hashCode() {
        return Objects.hash(this.completedDataNodeIds, this.nodeId2RemainingEventMap, this.nodeId2RemainingTimeMap);
    }

    public String toString() {
        return "PipeTemporaryMeta{completedDataNodeIds=" + this.completedDataNodeIds + ", nodeId2RemainingEventMap=" + this.nodeId2RemainingEventMap + ", nodeId2RemainingTimeMap" + this.nodeId2RemainingTimeMap + '}';
    }
}

