/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Window;

public class WindowReference
extends Node
implements Window {
    private final Identifier name;

    public WindowReference(NodeLocation location, Identifier name) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public Identifier getName() {
        return this.name;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWindowReference(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.name);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WindowReference o = (WindowReference)obj;
        return Objects.equals(this.name, o.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return WindowReference.sameClass(this, other);
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        this.name.serialize(byteBuffer);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        this.name.serialize(stream);
    }

    public WindowReference(ByteBuffer byteBuffer) {
        super(null);
        this.name = new Identifier(byteBuffer);
    }
}

