/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.eventsourcing.eventstore.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.BatchStatementBuilder;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.querybuilder.BuildableQuery;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.OngoingWhereClause;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.configuration.JamesExecutionProfiles;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.EventId$;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.eventsourcing.eventstore.History$;
import org.apache.james.eventsourcing.eventstore.cassandra.CassandraEventStoreTable$;
import org.apache.james.eventsourcing.eventstore.cassandra.JsonEventSerializer;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t}a\u0001\u0002\u0014(\u0001QB\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005{!Aa\n\u0001BC\u0002\u0013\u0005q\n\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003Q\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u001d\u0019\u0007A1A\u0005\n\u0011DaA\u001c\u0001!\u0002\u0013)\u0007bB8\u0001\u0005\u0004%I\u0001\u001d\u0005\u0007o\u0002\u0001\u000b\u0011B9\t\u000fa\u0004!\u0019!C\u0005a\"1\u0011\u0010\u0001Q\u0001\nEDqA\u001f\u0001C\u0002\u0013%\u0001\u000f\u0003\u0004|\u0001\u0001\u0006I!\u001d\u0005\by\u0002\u0011\r\u0011\"\u0003q\u0011\u0019i\b\u0001)A\u0005c\"9a\u0010\u0001b\u0001\n\u0013\u0001\bBB@\u0001A\u0003%\u0011\u000f\u0003\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0003q\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nED\u0011\"!\u0002\u0001\u0005\u0004%I!a\u0002\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u0013Aq!a\u0006\u0001\t\u0013\tI\u0002C\u0004\u0002\u001e\u0001!I!a\b\t\u000f\u0005\r\u0002\u0001\"\u0003\u0002&!9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0002bBA\u0018\u0001\u0011%\u0011\u0011\u0007\u0005\b\u0003k\u0001A\u0011BA\u001c\u0011!\tY\u0004\u0001C\u0001O\u0005u\u0002bBAG\u0001\u0011%\u0011q\u0012\u0005\b\u0003c\u0003A\u0011BAZ\u0011\u0019A\b\u0001\"\u0003\u0002@\"A\u0011q\u001a\u0001\u0005\u0002\u001d\n\t\u000e\u0003\u0005\u0002P\u0002!\taJAp\u0011\u001d\t)\u000f\u0001C\u0005\u0003OD\u0001\"a@\u0001\t\u00039#\u0011\u0001\u0005\b\u0005\u000f\u0001A\u0011\u0001B\u0005\u0011\u001d\u0011)\u0002\u0001C\u0005\u0005/\u0011Q\"\u0012<f]R\u001cFo\u001c:f\t\u0006|'B\u0001\u0015*\u0003%\u0019\u0017m]:b]\u0012\u0014\u0018M\u0003\u0002+W\u0005QQM^3oiN$xN]3\u000b\u00051j\u0013!D3wK:$8o\\;sG&twM\u0003\u0002/_\u0005)!.Y7fg*\u0011\u0001'M\u0001\u0007CB\f7\r[3\u000b\u0003I\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\r\u0005s\u0017PU3g\u0003\u001d\u0019Xm]:j_:,\u0012!\u0010\t\u0003}-k\u0011a\u0010\u0006\u0003\u0001\u0006\u000bAaY8sK*\u0011!iQ\u0001\u0004CBL'B\u0001#F\u0003\u0019!'/\u001b<fe*\u0011aiR\u0001\u0004_N\u001c(B\u0001%J\u0003!!\u0017\r^1ti\u0006D(\"\u0001&\u0002\u0007\r|W.\u0003\u0002M\u007f\tQ1)\u001d7TKN\u001c\u0018n\u001c8\u0002\u0011M,7o]5p]\u0002\n1C[:p]\u00163XM\u001c;TKJL\u0017\r\\5{KJ,\u0012\u0001\u0015\t\u0003#Jk\u0011aJ\u0005\u0003'\u001e\u00121CS:p]\u00163XM\u001c;TKJL\u0017\r\\5{KJ\fAC[:p]\u00163XM\u001c;TKJL\u0017\r\\5{KJ\u0004\u0013A\u0002\u001fj]&$h\bF\u0002X1f\u0003\"!\u0015\u0001\t\u000bm*\u0001\u0019A\u001f\t\u000b9+\u0001\u0019\u0001))\u0005\u0015Y\u0006C\u0001/b\u001b\u0005i&B\u00010`\u0003\u0019IgN[3di*\t\u0001-A\u0003kCZ\f\u00070\u0003\u0002c;\n1\u0011J\u001c6fGR\facY1tg\u0006tGM]1Bgft7-\u0012=fGV$xN]\u000b\u0002KB\u0011a\r\\\u0007\u0002O*\u0011\u0001.[\u0001\u0006kRLGn\u001d\u0006\u0003Q)T!a[\u0017\u0002\u0011\t\f7m[3oINL!!\\4\u0003-\r\u000b7o]1oIJ\f\u0017i]=oG\u0016CXmY;u_J\fqcY1tg\u0006tGM]1Bgft7-\u0012=fGV$xN\u001d\u0011\u0002\r%t7/\u001a:u+\u0005\t\bC\u0001:v\u001b\u0005\u0019(B\u0001;@\u0003\r\u0019\u0017\u000f\\\u0005\u0003mN\u0014\u0011\u0003\u0015:fa\u0006\u0014X\rZ*uCR,W.\u001a8u\u0003\u001dIgn]3si\u0002\na\"\u001b8tKJ$8K\\1qg\"|G/A\bj]N,'\u000f^*oCB\u001c\bn\u001c;!\u0003\u0019\u0019X\r\\3di\u000691/\u001a7fGR\u0004\u0013AC:fY\u0016\u001cGO\u0012:p[\u0006Y1/\u001a7fGR4%o\\7!\u00039\u0019X\r\\3diNs\u0017\r]:i_R\fqb]3mK\u000e$8K\\1qg\"|G\u000fI\u0001\u0014I\u0016dW\r^3Cs\u0006;wM]3hCR,\u0017\nZ\u0001\u0015I\u0016dW\r^3Cs\u0006;wM]3hCR,\u0017\n\u001a\u0011\u0002!\u0015DXmY;uS>t\u0007K]8gS2,WCAA\u0005!\u0011\tY!!\u0005\u000e\u0005\u00055!bAA\b\u007f\u000511m\u001c8gS\u001eLA!a\u0005\u0002\u000e\t1BI]5wKJ,\u00050Z2vi&|g\u000e\u0015:pM&dW-A\tfq\u0016\u001cW\u000f^5p]B\u0013xNZ5mK\u0002\nQ\u0002\u001d:fa\u0006\u0014X-\u00138tKJ$HcA9\u0002\u001c!)1H\u0006a\u0001{\u0005)\u0002O]3qCJ,\u0017J\\:feR\u001cf.\u00199tQ>$HcA9\u0002\"!)1h\u0006a\u0001{\u0005i\u0001O]3qCJ,7+\u001a7fGR$2!]A\u0014\u0011\u0015Y\u0004\u00041\u0001>\u0003U\u0001(/\u001a9be\u0016\u001cV\r\\3diNs\u0017\r]:i_R$2!]A\u0017\u0011\u0015Y\u0014\u00041\u0001>\u0003E\u0001(/\u001a9be\u0016\u001cV\r\\3di\u001a\u0013x.\u001c\u000b\u0004c\u0006M\u0002\"B\u001e\u001b\u0001\u0004i\u0014!\u00049sKB\f'/\u001a#fY\u0016$X\rF\u0002r\u0003sAQaO\u000eA\u0002u\n\u0011\"\u00199qK:$\u0017\t\u001c7\u0015\r\u0005}\u0012\u0011LA?!\u0019\t\t%a\u0014\u0002T5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%A\u0005qk\nd\u0017n\u001d5fe*\u0019\u0001(!\u0013\u000b\u0007\u0001\u000bYE\u0003\u0002\u0002N\u00059!/Z1di>\u0014\u0018\u0002BA)\u0003\u0007\u0012QaU'p]>\u00042ANA+\u0013\r\t9f\u000e\u0002\b\u0005>|G.Z1o\u0011\u001d\tY\u0006\ba\u0001\u0003;\na!\u001a<f]R\u001c\bCBA0\u0003_\n)H\u0004\u0003\u0002b\u0005-d\u0002BA2\u0003Sj!!!\u001a\u000b\u0007\u0005\u001d4'\u0001\u0004=e>|GOP\u0005\u0002q%\u0019\u0011QN\u001c\u0002\u000fA\f7m[1hK&!\u0011\u0011OA:\u0005!IE/\u001a:bE2,'bAA7oA!\u0011qOA=\u001b\u0005Y\u0013bAA>W\t)QI^3oi\"9\u0011q\u0010\u000fA\u0002\u0005\u0005\u0015\u0001\u00047bgR\u001cf.\u00199TQ>$\b#\u0002\u001c\u0002\u0004\u0006\u001d\u0015bAACo\t1q\n\u001d;j_:\u0004B!a\u001e\u0002\n&\u0019\u00111R\u0016\u0003\u000f\u00153XM\u001c;JI\u0006Y\u0011\r\u001d9f]\u0012\fV/\u001a:z)\u0011\t\t*a,1\t\u0005M\u0015Q\u0014\t\u0006e\u0006U\u0015\u0011T\u0005\u0004\u0003/\u001b(!C*uCR,W.\u001a8u!\u0011\tY*!(\r\u0001\u0011Y\u0011qT\u000f\u0002\u0002\u0003\u0005)\u0011AAQ\u0005\ryF%M\t\u0005\u0003G\u000bI\u000bE\u00027\u0003KK1!a*8\u0005\u001dqu\u000e\u001e5j]\u001e\u00042ANAV\u0013\r\tik\u000e\u0002\u0004\u0003:L\bbBA.;\u0001\u0007\u0011QL\u0001\fS:\u001cXM\u001d;Fm\u0016tG\u000f\u0006\u0003\u00026\u0006m\u0006c\u0001:\u00028&\u0019\u0011\u0011X:\u0003\u001d\t{WO\u001c3Ti\u0006$X-\\3oi\"9\u0011Q\u0018\u0010A\u0002\u0005U\u0014!B3wK:$HCBA[\u0003\u0003\fY\rC\u0004\u0002D~\u0001\r!!2\u0002\u0017\u0005<wM]3hCR,\u0017\n\u001a\t\u0005\u0003o\n9-C\u0002\u0002J.\u00121\"Q4he\u0016<\u0017\r^3JI\"9\u0011QZ\u0010A\u0002\u0005\u001d\u0015AC:oCB\u001c\bn\u001c;JI\u0006!r-\u001a;Fm\u0016tGo](g\u0003\u001e<'/Z4bi\u0016$B!a5\u0002^B1\u0011\u0011IA(\u0003+\u0004B!a6\u0002Z6\t\u0011&C\u0002\u0002\\&\u0012q\u0001S5ti>\u0014\u0018\u0010C\u0004\u0002D\u0002\u0002\r!!2\u0015\r\u0005M\u0017\u0011]Ar\u0011\u001d\t\u0019-\ta\u0001\u0003\u000bDq!!4\"\u0001\u0004\t9)A\u0005bg\"K7\u000f^8ssR!\u00111[Au\u0011\u001d\tYO\ta\u0001\u0003[\fAA]8xgB1\u0011q^A{\u0003sl!!!=\u000b\u0007\u0005M\u0018'A\bsK\u0006\u001cG/\u001b<fgR\u0014X-Y7t\u0013\u0011\t90!=\u0003\u0013A+(\r\\5tQ\u0016\u0014\bc\u0001:\u0002|&\u0019\u0011Q`:\u0003\u0007I{w/A\u0006hKR\u001cf.\u00199tQ>$H\u0003\u0002B\u0002\u0005\u000b\u0001b!!\u0011\u0002P\u0005\u001d\u0005bBAbG\u0001\u0007\u0011QY\u0001\u0007I\u0016dW\r^3\u0015\t\t-!1\u0003\t\u0007\u0003\u0003\nyE!\u0004\u0011\u0007Y\u0012y!C\u0002\u0003\u0012]\u0012A!\u00168ji\"9\u00111\u0019\u0013A\u0002\u0005\u0015\u0017a\u0002;p\u000bZ,g\u000e\u001e\u000b\u0005\u00053\u0011Y\u0002\u0005\u0004\u0002B\u0005=\u0013Q\u000f\u0005\b\u0005;)\u0003\u0019AA}\u0003\r\u0011xn\u001e")
public class EventStoreDao {
    private final CqlSession session;
    private final JsonEventSerializer jsonEventSerializer;
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement insert;
    private final PreparedStatement insertSnapshot;
    private final PreparedStatement select;
    private final PreparedStatement selectFrom;
    private final PreparedStatement selectSnapshot;
    private final PreparedStatement deleteByAggregateId;
    private final DriverExecutionProfile executionProfile;

    public CqlSession session() {
        return this.session;
    }

    public JsonEventSerializer jsonEventSerializer() {
        return this.jsonEventSerializer;
    }

    private CassandraAsyncExecutor cassandraAsyncExecutor() {
        return this.cassandraAsyncExecutor;
    }

    private PreparedStatement insert() {
        return this.insert;
    }

    private PreparedStatement insertSnapshot() {
        return this.insertSnapshot;
    }

    private PreparedStatement select() {
        return this.select;
    }

    private PreparedStatement selectFrom() {
        return this.selectFrom;
    }

    private PreparedStatement selectSnapshot() {
        return this.selectSnapshot;
    }

    private PreparedStatement deleteByAggregateId() {
        return this.deleteByAggregateId;
    }

    private DriverExecutionProfile executionProfile() {
        return this.executionProfile;
    }

    private PreparedStatement prepareInsert(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)CassandraEventStoreTable$.MODULE$.EVENTS_TABLE()).value(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID(), (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.AGGREGATE_ID())).value(CassandraEventStoreTable$.MODULE$.EVENT_ID(), (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.EVENT_ID())).value(CassandraEventStoreTable$.MODULE$.EVENT(), (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.EVENT())).ifNotExists().build());
    }

    private PreparedStatement prepareInsertSnapshot(CqlSession session) {
        return session.prepare(((BuildableQuery)QueryBuilder.update((String)CassandraEventStoreTable$.MODULE$.EVENTS_TABLE()).setColumn(CassandraEventStoreTable$.MODULE$.SNAPSHOT(), (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.SNAPSHOT())).whereColumn(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()))).build());
    }

    private PreparedStatement prepareSelect(CqlSession session) {
        return session.prepare(((BuildableQuery)QueryBuilder.selectFrom((String)CassandraEventStoreTable$.MODULE$.EVENTS_TABLE()).column(CassandraEventStoreTable$.MODULE$.EVENT()).whereColumn(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()))).build());
    }

    private PreparedStatement prepareSelectSnapshot(CqlSession session) {
        return session.prepare(((BuildableQuery)QueryBuilder.selectFrom((String)CassandraEventStoreTable$.MODULE$.EVENTS_TABLE()).column(CassandraEventStoreTable$.MODULE$.SNAPSHOT()).whereColumn(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()))).build());
    }

    private PreparedStatement prepareSelectFrom(CqlSession session) {
        return session.prepare(((BuildableQuery)((OngoingWhereClause)QueryBuilder.selectFrom((String)CassandraEventStoreTable$.MODULE$.EVENTS_TABLE()).column(CassandraEventStoreTable$.MODULE$.EVENT()).whereColumn(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()))).whereColumn(CassandraEventStoreTable$.MODULE$.EVENT_ID()).isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.EVENT_ID()))).build());
    }

    private PreparedStatement prepareDelete(CqlSession session) {
        return session.prepare(((BuildableQuery)QueryBuilder.deleteFrom((String)CassandraEventStoreTable$.MODULE$.EVENTS_TABLE()).whereColumn(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()))).build());
    }

    public SMono<Object> appendAll(Iterable<Event> events, Option<EventId> lastSnapShot) {
        return SMono$.MODULE$.apply((Publisher)this.cassandraAsyncExecutor().executeReturnApplied(this.appendQuery(events)).map(x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1))).flatMap((Function1 & Serializable)success -> EventStoreDao.$anonfun$appendAll$2(this, lastSnapShot, events, BoxesRunTime.unboxToBoolean((Object)success)));
    }

    private Statement<?> appendQuery(Iterable<Event> events) {
        if (events.size() == 1) {
            return this.insertEvent((Event)events.head());
        }
        BatchStatementBuilder batch = new BatchStatementBuilder(BatchType.LOGGED);
        events.foreach((Function1 & Serializable)event -> batch.addStatement((BatchableStatement)this.insertEvent((Event)event)));
        return batch.build();
    }

    private BoundStatement insertEvent(Event event) {
        return (BoundStatement)this.insert().bind(new Object[0]).setString(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID(), event.getAggregateId().asAggregateKey()).setInt(CassandraEventStoreTable$.MODULE$.EVENT_ID(), event.eventId().serialize()).setString(CassandraEventStoreTable$.MODULE$.EVENT(), this.jsonEventSerializer().serialize(event));
    }

    private BoundStatement insertSnapshot(AggregateId aggregateId, EventId snapshotId) {
        return (BoundStatement)this.insertSnapshot().bind(new Object[0]).setString(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID(), aggregateId.asAggregateKey()).setInt(CassandraEventStoreTable$.MODULE$.SNAPSHOT(), snapshotId.serialize());
    }

    public SMono<History> getEventsOfAggregate(AggregateId aggregateId) {
        return this.asHistory((Publisher<Row>)this.cassandraAsyncExecutor().executeRows(((Statement)this.select().bind(new Object[0]).set(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID(), (Object)aggregateId.asAggregateKey(), TypeCodecs.TEXT)).setExecutionProfile(this.executionProfile())));
    }

    public SMono<History> getEventsOfAggregate(AggregateId aggregateId, EventId snapshotId) {
        return this.asHistory((Publisher<Row>)this.cassandraAsyncExecutor().executeRows(((Statement)this.selectFrom().bind(new Object[0]).set(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID(), (Object)aggregateId.asAggregateKey(), TypeCodecs.TEXT).setInt(CassandraEventStoreTable$.MODULE$.EVENT_ID(), snapshotId.value())).setExecutionProfile(this.executionProfile())));
    }

    private SMono<History> asHistory(Publisher<Row> rows) {
        SFlux qual$1 = SFlux$.MODULE$.apply(rows);
        Function1 & Serializable x$1 = (Function1 & Serializable)row -> this.toEvent((Row)row);
        int x$2 = qual$1.concatMap$default$2();
        return qual$1.concatMap((Function1)x$1, x$2).collectSeq().map((Function1 & Serializable)x$3 -> x$3.toList()).map((Function1 & Serializable)x$4 -> History$.MODULE$.of(x$4));
    }

    public SMono<EventId> getSnapshot(AggregateId aggregateId) {
        return SMono$.MODULE$.apply((Publisher)this.cassandraAsyncExecutor().executeSingleRow((Statement)this.selectSnapshot().bind(new Object[0]).set(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID(), (Object)aggregateId.asAggregateKey(), TypeCodecs.TEXT))).map((Function1 & Serializable)row -> EventId$.MODULE$.fromSerialized(Predef$.MODULE$.Integer2int((Integer)row.get(0, (TypeCodec)TypeCodecs.INT))));
    }

    public SMono<BoxedUnit> delete(AggregateId aggregateId) {
        return SMono$.MODULE$.apply((Publisher)this.cassandraAsyncExecutor().executeVoid((Statement)this.deleteByAggregateId().bind(new Object[0]).setString(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID(), aggregateId.asAggregateKey()))).then();
    }

    private SMono<Event> toEvent(Row row) {
        return SMono$.MODULE$.fromCallable(() -> this.jsonEventSerializer().deserialize((String)row.get(0, TypeCodecs.TEXT))).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    public static final /* synthetic */ SMono $anonfun$appendAll$2(EventStoreDao $this, Option lastSnapShot$1, Iterable events$1, boolean success) {
        return ((SMono)lastSnapShot$1.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)success)).map((Function1 & Serializable)id -> SMono$.MODULE$.apply((Publisher)$this.cassandraAsyncExecutor().executeVoid((Statement)$this.insertSnapshot(((Event)events$1.head()).getAggregateId(), (EventId)id)))).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty())).then(SMono$.MODULE$.just((Object)BoxesRunTime.boxToBoolean((boolean)success)));
    }

    @Inject
    public EventStoreDao(CqlSession session, JsonEventSerializer jsonEventSerializer) {
        this.session = session;
        this.jsonEventSerializer = jsonEventSerializer;
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.insert = this.prepareInsert(session);
        this.insertSnapshot = this.prepareInsertSnapshot(session);
        this.select = this.prepareSelect(session);
        this.selectFrom = this.prepareSelectFrom(session);
        this.selectSnapshot = this.prepareSelectSnapshot(session);
        this.deleteByAggregateId = this.prepareDelete(session);
        this.executionProfile = JamesExecutionProfiles.getLWTProfile((CqlSession)session);
    }
}

