/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Content;

class ContentBodyElement
implements FetchResponse.BodyElement {
    private final String name;
    protected final Content content;

    public ContentBodyElement(String name, Content content) {
        this.name = name;
        this.content = content;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long size() throws IOException {
        try {
            return this.content.size();
        }
        catch (MailboxException e) {
            throw new IOException("Unable to get size for body element", e);
        }
    }

    @Override
    public Optional<byte[][]> asBytesSequence() {
        return this.content.asBytesSequence();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.content.getInputStream();
    }

    public String toString() {
        return "ContentBodyElement{name='" + this.getName() + "', content=" + String.valueOf(this.content) + "}";
    }
}

