/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.mailbox;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;

public class MaxQuotaConfigurationReader
implements Configurable {
    private final MaxQuotaManager maxQuotaManager;
    private final QuotaRootResolver quotaRootResolver;

    public MaxQuotaConfigurationReader(MaxQuotaManager maxQuotaManager, QuotaRootResolver quotaRootResolver) {
        this.maxQuotaManager = maxQuotaManager;
        this.quotaRootResolver = quotaRootResolver;
    }

    public void configure(HierarchicalConfiguration<ImmutableNode> config) throws ConfigurationException {
        Long globalMaxMessage = config.configurationAt("maxQuotaManager").getLong("globalMaxMessage", null);
        Long globalMaxStorage = config.configurationAt("maxQuotaManager").getLong("globalMaxStorage", null);
        Map<String, Long> maxMessage = this.parseMaxMessageConfiguration(config, "maxMessage");
        Map<String, Long> maxStorage = this.parseMaxMessageConfiguration(config, "maxStorage");
        try {
            this.configureGlobalValues(globalMaxMessage, globalMaxStorage);
            this.configureQuotaRootSpecificValues(maxMessage, maxStorage);
        }
        catch (MailboxException e) {
            throw new ConfigurationException("Exception caught while configuring max quota manager", (Throwable)e);
        }
    }

    private Map<String, Long> parseMaxMessageConfiguration(HierarchicalConfiguration<ImmutableNode> config, String entry) {
        List maxMessageConfiguration = config.configurationAt("maxQuotaManager").configurationsAt(entry);
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (HierarchicalConfiguration conf : maxMessageConfiguration) {
            result.put(conf.getString("quotaRoot"), conf.getLong("value"));
        }
        return result;
    }

    private void configureGlobalValues(Long globalMaxMessage, Long globalMaxStorage) throws MailboxException {
        if (globalMaxMessage != null) {
            this.maxQuotaManager.setGlobalMaxMessage(QuotaCountLimit.count((long)globalMaxMessage));
        }
        if (globalMaxStorage != null) {
            this.maxQuotaManager.setGlobalMaxStorage(QuotaSizeLimit.size((long)globalMaxStorage));
        }
    }

    private void configureQuotaRootSpecificValues(Map<String, Long> maxMessage, Map<String, Long> maxStorage) throws MailboxException {
        for (Map.Entry<String, Long> entry : maxMessage.entrySet()) {
            this.maxQuotaManager.setMaxMessage(this.toQuotaRoot(entry.getKey()), QuotaCountLimit.count((long)entry.getValue()));
        }
        for (Map.Entry<String, Long> entry : maxStorage.entrySet()) {
            this.maxQuotaManager.setMaxStorage(this.toQuotaRoot(entry.getKey()), QuotaSizeLimit.size((long)entry.getValue()));
        }
    }

    private QuotaRoot toQuotaRoot(String serializedKey) throws MailboxException {
        return this.quotaRootResolver.fromString(serializedKey);
    }
}

