/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.james.server.core.MimeMessageWrapper;

public class MimeMessageInputStream
extends InputStream {
    private final InputStream in;

    public MimeMessageInputStream(MimeMessage message, boolean tryCast) throws MessagingException {
        if (tryCast && message instanceof MimeMessageWrapper) {
            this.in = ((MimeMessageWrapper)message).getMessageInputStream();
        } else {
            UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream();
            try {
                message.writeTo((OutputStream)out);
                this.in = out.toInputStream();
            }
            catch (IOException e1) {
                throw new MessagingException("Unable to read message " + String.valueOf(message), (Exception)e1);
            }
        }
    }

    public MimeMessageInputStream(MimeMessage message) throws MessagingException {
        this(message, true);
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }
}

