/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRuleMessages;
import com.unboundid.ldap.matchingrules.SimpleMatchingRule;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class NumericStringMatchingRule
extends SimpleMatchingRule {
    @NotNull
    private static final NumericStringMatchingRule INSTANCE = new NumericStringMatchingRule();
    @NotNull
    public static final String EQUALITY_RULE_NAME = "numericStringMatch";
    @NotNull
    static final String LOWER_EQUALITY_RULE_NAME = StaticUtils.toLowerCase("numericStringMatch");
    @NotNull
    public static final String EQUALITY_RULE_OID = "2.5.13.8";
    @NotNull
    public static final String ORDERING_RULE_NAME = "numericStringOrderingMatch";
    @NotNull
    static final String LOWER_ORDERING_RULE_NAME = StaticUtils.toLowerCase("numericStringOrderingMatch");
    @NotNull
    public static final String ORDERING_RULE_OID = "2.5.13.9";
    @NotNull
    public static final String SUBSTRING_RULE_NAME = "numericStringSubstringsMatch";
    @NotNull
    static final String LOWER_SUBSTRING_RULE_NAME = StaticUtils.toLowerCase("numericStringSubstringsMatch");
    @NotNull
    public static final String SUBSTRING_RULE_OID = "2.5.13.10";
    private static final long serialVersionUID = -898484312052746321L;

    @NotNull
    public static NumericStringMatchingRule getInstance() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public String getEqualityMatchingRuleName() {
        return EQUALITY_RULE_NAME;
    }

    @Override
    @NotNull
    public String getEqualityMatchingRuleOID() {
        return EQUALITY_RULE_OID;
    }

    @Override
    @NotNull
    public String getOrderingMatchingRuleName() {
        return ORDERING_RULE_NAME;
    }

    @Override
    @NotNull
    public String getOrderingMatchingRuleOID() {
        return ORDERING_RULE_OID;
    }

    @Override
    @NotNull
    public String getSubstringMatchingRuleName() {
        return SUBSTRING_RULE_NAME;
    }

    @Override
    @NotNull
    public String getSubstringMatchingRuleOID() {
        return SUBSTRING_RULE_OID;
    }

    @Override
    @NotNull
    public ASN1OctetString normalize(@NotNull ASN1OctetString value) throws LDAPException {
        int numSpaces = 0;
        byte[] valueBytes = value.getValue();
        for (int i = 0; i < valueBytes.length; ++i) {
            if (valueBytes[i] == 32) {
                ++numSpaces;
                continue;
            }
            if (valueBytes[i] >= 48 && valueBytes[i] <= 57) continue;
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_NUMERIC_STRING_INVALID_CHARACTER.get(i));
        }
        if (numSpaces == 0) {
            return value;
        }
        int pos = 0;
        byte[] returnBytes = new byte[valueBytes.length - numSpaces];
        for (byte b : valueBytes) {
            if (b == 32) continue;
            returnBytes[pos++] = b;
        }
        return new ASN1OctetString(returnBytes);
    }

    @Override
    @NotNull
    public ASN1OctetString normalizeSubstring(@NotNull ASN1OctetString value, byte substringType) throws LDAPException {
        return this.normalize(value);
    }
}

