/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.atom;

import java.util.Calendar;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.dto.atom.Category;
import org.apache.juneau.dto.atom.CommonEntry;
import org.apache.juneau.dto.atom.Content;
import org.apache.juneau.dto.atom.Id;
import org.apache.juneau.dto.atom.Link;
import org.apache.juneau.dto.atom.Person;
import org.apache.juneau.dto.atom.Source;
import org.apache.juneau.dto.atom.Text;
import org.apache.juneau.dto.atom.Utils;

@Bean(typeName="entry")
public class Entry
extends CommonEntry {
    private Content content;
    private Calendar published;
    private Source source;
    private Text summary;

    public Entry(Id id, Text title, Calendar updated) {
        super(id, title, updated);
    }

    public Entry(String id, String title, String updated) {
        super(id, title, updated);
    }

    public Entry() {
    }

    public Content getContent() {
        return this.content;
    }

    @Beanp(value="content")
    public Entry content(Content content) {
        this.content = content;
        return this;
    }

    public Calendar getPublished() {
        return this.published;
    }

    @Beanp(value="published")
    public Entry published(Calendar published) {
        this.published = published;
        return this;
    }

    @Beanp(value="published")
    public Entry published(String published) {
        this.published = Utils.parseDateTime(published);
        return this;
    }

    public Source getSource() {
        return this.source;
    }

    @Beanp(value="source")
    public Entry source(Source source) {
        this.source = source;
        return this;
    }

    public Text getSummary() {
        return this.summary;
    }

    @Beanp(value="summary")
    public Entry summary(Text summary) {
        this.summary = summary;
        return this;
    }

    @Beanp(value="summary")
    public Entry summary(String summary) {
        this.summary = new Text(summary);
        return this;
    }

    @Override
    public Entry authors(Person ... authors) {
        super.authors(authors);
        return this;
    }

    @Override
    public Entry categories(Category ... categories) {
        super.categories(categories);
        return this;
    }

    @Override
    public Entry contributors(Person ... contributors) {
        super.contributors(contributors);
        return this;
    }

    @Override
    public Entry id(Id id) {
        super.id(id);
        return this;
    }

    @Override
    public Entry links(Link ... links) {
        super.links(links);
        return this;
    }

    @Override
    public Entry rights(Text rights) {
        super.rights(rights);
        return this;
    }

    @Override
    public Entry rights(String rights) {
        super.rights(rights);
        return this;
    }

    @Override
    public Entry title(Text title) {
        super.title(title);
        return this;
    }

    @Override
    public Entry title(String title) {
        super.title(title);
        return this;
    }

    @Override
    public Entry updated(Calendar updated) {
        super.updated(updated);
        return this;
    }

    @Override
    public Entry updated(String updated) {
        super.updated(updated);
        return this;
    }

    @Override
    public Entry base(Object base) {
        super.base(base);
        return this;
    }

    @Override
    public Entry lang(String lang) {
        super.lang(lang);
        return this;
    }
}

