/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.util.List;
import java.util.ListIterator;
import org.apache.juneau.BeanContext;
import org.apache.juneau.PropertyNamerDefault;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.transform.BeanFilterBuilder;

public class InterfaceBeanFilterBuilder<T>
extends BeanFilterBuilder<T> {
    protected InterfaceBeanFilterBuilder() {
        this.init(this.beanClass, BeanContext.DEFAULT);
    }

    public InterfaceBeanFilterBuilder(Class<T> interfaceClass, BeanContext bc) {
        super(interfaceClass);
        this.init(interfaceClass, bc);
    }

    private void init(Class<?> interfaceClass, BeanContext bc) {
        this.interfaceClass(interfaceClass);
        List<Bean> annotations = ClassInfo.of(interfaceClass).getAnnotations(Bean.class, bc);
        ListIterator<Bean> li = annotations.listIterator(annotations.size());
        while (li.hasPrevious()) {
            Bean b = li.previous();
            if (!b.properties().isEmpty()) {
                this.bpi(StringUtils.split(b.properties()));
            }
            if (!b.excludeProperties().isEmpty()) {
                this.bpx(StringUtils.split(b.excludeProperties()));
            }
            if (!b.bpi().isEmpty()) {
                this.bpi(StringUtils.split(b.bpi()));
            }
            if (!b.bpx().isEmpty()) {
                this.bpx(StringUtils.split(b.bpx()));
            }
            if (!b.bpro().isEmpty()) {
                this.bpro(StringUtils.split(b.bpro()));
            }
            if (!b.bpwo().isEmpty()) {
                this.bpwo(StringUtils.split(b.bpwo()));
            }
            if (!b.typeName().isEmpty()) {
                this.typeName(b.typeName());
            }
            if (b.sort()) {
                this.sortProperties(true);
            }
            if (b.fluentSetters()) {
                this.fluentSetters(true);
            }
            try {
                if (b.propertyNamer() != PropertyNamerDefault.class) {
                    this.propertyNamer(b.propertyNamer());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (b.interfaceClass() != Object.class) {
                this.interfaceClass(b.interfaceClass());
            }
            if (b.stopClass() != Object.class) {
                this.stopClass(b.stopClass());
            }
            if (b.beanDictionary().length > 0) {
                this.dictionary(b.beanDictionary());
            }
            if (b.dictionary().length <= 0) continue;
            this.dictionary(b.dictionary());
        }
    }
}

