/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflect;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.internal.ConsumerUtils;
import org.apache.juneau.reflect.AnnotationInfo;

public final class AnnotationList
extends ArrayList<AnnotationInfo<?>> {
    private static final long serialVersionUID = 1L;
    private static final Comparator<AnnotationInfo<?>> RANK_COMPARATOR = (o1, o2) -> o1.rank - o2.rank;

    public AnnotationList sort() {
        Collections.sort(this, RANK_COMPARATOR);
        return this;
    }

    public <T> AnnotationList forEachValue(Class<T> type, String name, Predicate<T> filter, Consumer<T> action) {
        this.forEach((? super E x) -> x.forEachValue(type, name, filter, action));
        return this;
    }

    public <A extends Annotation> AnnotationList forEach(Class<A> type, Predicate<AnnotationInfo<A>> filter, Consumer<AnnotationInfo<A>> action) {
        this.forEach((? super E x) -> {
            if (x.isType(type)) {
                ConsumerUtils.consume(filter, action, x);
            }
        });
        return this;
    }

    public <A extends Annotation> AnnotationList forEach(Predicate<AnnotationInfo<?>> filter, Consumer<AnnotationInfo<?>> action) {
        this.forEach((? super E x) -> ConsumerUtils.consume(filter, action, x));
        return this;
    }
}

