/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.AnnotationProvider;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.Value;
import org.apache.juneau.Visibility;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.ConsumerUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ExecutableInfo;

@FluentSetters
public final class ConstructorInfo
extends ExecutableInfo
implements Comparable<ConstructorInfo> {
    private final Constructor<?> c;

    public static ConstructorInfo of(ClassInfo declaringClass, Constructor<?> c) {
        if (c == null) {
            return null;
        }
        return ClassInfo.of(declaringClass).getConstructorInfo(c);
    }

    public static ConstructorInfo of(Constructor<?> c) {
        if (c == null) {
            return null;
        }
        return ClassInfo.of(c.getDeclaringClass()).getConstructorInfo(c);
    }

    protected ConstructorInfo(ClassInfo declaringClass, Constructor<?> c) {
        super(declaringClass, c);
        this.c = c;
    }

    public <T> Constructor<T> inner() {
        return this.c;
    }

    public <A extends Annotation> A getAnnotation(Class<A> type) {
        return this.getAnnotation(AnnotationProvider.DEFAULT, type);
    }

    public <A extends Annotation> A getAnnotation(AnnotationProvider annotationProvider, Class<A> type) {
        Value<Object> t = Value.empty();
        annotationProvider.forEachAnnotation(type, this.c, x -> true, x -> t.set(x));
        return (A)((Annotation)t.orElse(null));
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> type) {
        return this.hasAnnotation(AnnotationProvider.DEFAULT, type);
    }

    public <A extends Annotation> boolean hasAnnotation(AnnotationProvider annotationProvider, Class<A> type) {
        return annotationProvider.firstAnnotation(type, this.c, x -> true) != null;
    }

    public <A extends Annotation> boolean hasNoAnnotation(AnnotationProvider annotationProvider, Class<A> type) {
        return !this.hasAnnotation(annotationProvider, type);
    }

    public boolean matches(Predicate<ConstructorInfo> test) {
        return ConsumerUtils.test(test, this);
    }

    public ConstructorInfo accept(Predicate<ConstructorInfo> test, Consumer<ConstructorInfo> action) {
        if (this.matches(test)) {
            action.accept(this);
        }
        return this;
    }

    public boolean canAccept(Object ... args) {
        Class<?>[] pt = this.c.getParameterTypes();
        if (pt.length != args.length) {
            return false;
        }
        for (int i = 0; i < pt.length; ++i) {
            if (pt[i].isInstance(args[i])) continue;
            return false;
        }
        return true;
    }

    public <T> T invokeFuzzy(Object ... args) throws ExecutableException {
        return this.invoke(ClassUtils.getMatchingArgs(this.c.getParameterTypes(), args));
    }

    public <T> T invoke(Object ... args) throws ExecutableException {
        try {
            return (T)this.c.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw new ExecutableException(e.getTargetException());
        }
        catch (Exception e) {
            throw new ExecutableException(e);
        }
    }

    public ConstructorInfo accessible(Visibility v) {
        if (v.transform(this.c) == null) {
            return null;
        }
        return this;
    }

    @Override
    public int compareTo(ConstructorInfo o) {
        int i = this.getSimpleName().compareTo(o.getSimpleName());
        if (i == 0 && (i = this.getParamCount() - o.getParamCount()) == 0) {
            for (int j = 0; j < this.getParamCount() && i == 0; ++j) {
                Class<?>[] tpt = this._getRawParamTypes();
                Class<?>[] opt = o._getRawParamTypes();
                i = tpt[j].getName().compareTo(opt[j].getName());
            }
        }
        return i;
    }

    @Override
    public ConstructorInfo accessible() {
        super.accessible();
        return this;
    }
}

