/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.arg.ArgException;
import org.apache.juneau.rest.arg.RestOpArg;

public class ResponseBeanArg
implements RestOpArg {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    final ResponseBeanMeta meta;
    private final Type type;

    public static ResponseBeanArg create(ParameterInfo paramInfo, AnnotationWorkList annotations) {
        if (AP.has(Response.class, paramInfo, new AnnotationTraversal[0])) {
            return new ResponseBeanArg(paramInfo, annotations);
        }
        return null;
    }

    protected ResponseBeanArg(ParameterInfo paramInfo, AnnotationWorkList annotations) {
        Class c;
        this.type = paramInfo.getParameterType().innerType();
        this.meta = ResponseBeanMeta.create((ParameterInfo)paramInfo, (AnnotationWorkList)annotations);
        Class clazz = this.type instanceof Class ? (Class)this.type : (c = this.type instanceof ParameterizedType ? (Class)((ParameterizedType)this.type).getRawType() : null);
        if (c != Value.class) {
            throw new ArgException(paramInfo, "Type must be Value<?> on parameter annotated with @Response annotation", new Object[0]);
        }
    }

    @Override
    public Object resolve(RestOpSession opSession) throws Exception {
        Value v = new Value();
        v.listener(o -> {
            RestRequest req = opSession.getRequest();
            RestResponse res = opSession.getResponse();
            ResponseBeanMeta meta = req.getOpContext().getResponseBeanMeta(o);
            if (meta == null) {
                meta = this.meta;
            }
            res.setResponseBeanMeta(meta);
            res.setContent(o);
        });
        return v;
    }
}

