/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.config.Config;
import org.apache.juneau.config.internal.ConfigMap;
import org.apache.juneau.parser.ParseException;

public class Section {
    final Config config;
    private final ConfigMap configMap;
    final String name;

    protected Section(Config config, ConfigMap configMap, String name) {
        this.config = config;
        this.configMap = configMap;
        this.name = name;
    }

    public <T> Optional<T> asBean(Class<T> c) throws ParseException {
        return this.asBean(c, false);
    }

    public <T> Optional<T> asBean(Class<T> c, boolean ignoreUnknownProperties) throws ParseException {
        AssertionUtils.assertArgNotNull((String)"c", c);
        if (!this.isPresent()) {
            return Utils.opte();
        }
        Set<String> keys = this.configMap.getKeys(this.name);
        BeanMap bm = this.config.beanSession.newBeanMap(c);
        for (String k : keys) {
            BeanPropertyMeta bpm = bm.getPropertyMeta(k);
            if (bpm == null) {
                if (ignoreUnknownProperties) continue;
                throw new ParseException("Unknown property ''{0}'' encountered in configuration section ''{1}''.", new Object[]{k, this.name});
            }
            bm.put(k, this.config.get(this.name + "/" + k).as(bpm.getClassMeta().inner()).orElse(null));
        }
        return Utils.opt((Object)bm.getBean());
    }

    public <T> Optional<T> asInterface(Class<T> c) {
        AssertionUtils.assertArgNotNull((String)"c", c);
        if (!c.isInterface()) {
            throw ThrowableUtils.illegalArg((String)"Class ''{0}'' passed to toInterface() is not an interface.", (Object[])new Object[]{Utils.cn(c)});
        }
        return Utils.opt((Object)Proxy.newProxyInstance(c.getClassLoader(), (Class[])CollectionUtils.a((Object[])new Class[]{c}), (proxy, method, args) -> {
            BeanInfo bi = Introspector.getBeanInfo(c, null);
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                Method rm = pd.getReadMethod();
                Method wm = pd.getWriteMethod();
                if (method.equals(rm)) {
                    return this.config.get(this.name + "/" + pd.getName()).as(rm.getGenericReturnType(), new Type[0]).orElse(null);
                }
                if (!method.equals(wm)) continue;
                return this.config.set(this.name + "/" + pd.getName(), args[0]);
            }
            throw ThrowableUtils.unsupportedOp((String)"Unsupported interface method.  method=''{0}''", (Object[])new Object[]{method});
        }));
    }

    public Optional<JsonMap> asMap() {
        if (!this.isPresent()) {
            return Utils.opte();
        }
        Set<String> keys = this.configMap.getKeys(this.name);
        JsonMap m = new JsonMap();
        for (String k : keys) {
            m.put(k, this.config.get(this.name + "/" + k).as(Object.class).orElse(null));
        }
        return Utils.opt((Object)m);
    }

    public boolean isPresent() {
        return this.configMap.hasSection(this.name);
    }

    public Section writeToBean(Object bean, boolean ignoreUnknownProperties) throws ParseException {
        AssertionUtils.assertArgNotNull((String)"bean", (Object)bean);
        if (!this.isPresent()) {
            throw ThrowableUtils.illegalArg((String)"Section ''{0}'' not found in configuration.", (Object[])new Object[]{this.name});
        }
        Set<String> keys = this.configMap.getKeys(this.name);
        BeanMap bm = this.config.beanSession.toBeanMap(bean);
        for (String k : keys) {
            BeanPropertyMeta bpm = bm.getPropertyMeta(k);
            if (bpm == null) {
                if (ignoreUnknownProperties) continue;
                throw new ParseException("Unknown property ''{0}'' encountered in configuration section ''{1}''.", new Object[]{k, this.name});
            }
            bm.put(k, this.config.get(this.name + "/" + k).as(bpm.getClassMeta().inner()).orElse(null));
        }
        return this;
    }
}

