/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.lang;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.apache.juneau.commons.utils.AnnotationUtils;

public class HashCode {
    private int hashCode = 1;

    public static final HashCode create() {
        return new HashCode();
    }

    public static final int of(Object ... objects) {
        HashCode x = HashCode.create();
        for (Object oo : objects) {
            x.add(oo);
        }
        return x.get();
    }

    public HashCode add(int i) {
        this.hashCode = 31 * this.hashCode + i;
        return this;
    }

    public HashCode add(Object o) {
        if ((o = this.unswap(o)) == null) {
            this.add(0);
        } else if (o instanceof Annotation) {
            Annotation a = (Annotation)o;
            this.add(AnnotationUtils.hash(a));
        } else if (o.getClass().isArray()) {
            if (o instanceof Object[]) {
                Object[] o2 = (Object[])o;
                this.add(Arrays.deepHashCode(o2));
            } else if (o instanceof int[]) {
                int[] o2 = (int[])o;
                this.add(Arrays.hashCode(o2));
            } else if (o instanceof long[]) {
                long[] o2 = (long[])o;
                this.add(Arrays.hashCode(o2));
            } else if (o instanceof short[]) {
                short[] o2 = (short[])o;
                this.add(Arrays.hashCode(o2));
            } else if (o instanceof byte[]) {
                byte[] o2 = (byte[])o;
                this.add(Arrays.hashCode(o2));
            } else if (o instanceof char[]) {
                char[] o2 = (char[])o;
                this.add(Arrays.hashCode(o2));
            } else if (o instanceof boolean[]) {
                boolean[] o2 = (boolean[])o;
                this.add(Arrays.hashCode(o2));
            } else if (o instanceof float[]) {
                float[] o2 = (float[])o;
                this.add(Arrays.hashCode(o2));
            } else if (o instanceof double[]) {
                double[] o2 = (double[])o;
                this.add(Arrays.hashCode(o2));
            }
        } else {
            this.add(o.hashCode());
        }
        return this;
    }

    public int get() {
        return this.hashCode;
    }

    protected Object unswap(Object o) {
        return o;
    }
}

