/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.juneau.commons.io.NoCloseOutputStream;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.entity.BasicHttpEntity;
import org.apache.juneau.http.header.ContentEncoding;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerSession;

public class SerializedEntity
extends BasicHttpEntity {
    Serializer serializer;
    HttpPartSchema schema;

    public SerializedEntity() {
    }

    public SerializedEntity(ContentType contentType, Object content, Serializer serializer, HttpPartSchema schema) {
        super(contentType, content);
        this.serializer = serializer;
        this.schema = schema;
    }

    public SerializedEntity(SerializedEntity copyFrom) {
        super(copyFrom);
        this.serializer = copyFrom.serializer;
        this.schema = copyFrom.schema;
    }

    @Override
    public SerializedEntity copy() {
        return new SerializedEntity(this);
    }

    public SerializedEntity copyWith(Serializer serializer, HttpPartSchema schema) {
        if (this.serializer == null && Utils.nn(serializer) || this.schema == null && Utils.nn(schema)) {
            SerializedEntity h = this.copy();
            if (Utils.nn(serializer)) {
                h.setSerializer(serializer);
            }
            if (Utils.nn(schema)) {
                h.setSchema(schema);
            }
            return h;
        }
        return this;
    }

    @Override
    public InputStream getContent() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.writeTo(baos);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException e) {
            throw ThrowableUtils.toRex(e);
        }
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public Header getContentType() {
        Header x = super.getContentType();
        if (x == null && Utils.nn(this.serializer)) {
            x = HttpHeaders.contentType(this.serializer.getPrimaryMediaType());
        }
        return x;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public SerializedEntity setCached() throws IOException {
        super.setCached();
        return this;
    }

    @Override
    public SerializedEntity setCharset(Charset value) {
        super.setCharset(value);
        return this;
    }

    @Override
    public SerializedEntity setChunked() {
        super.setChunked();
        return this;
    }

    @Override
    public SerializedEntity setChunked(boolean value) {
        super.setChunked(value);
        return this;
    }

    @Override
    public SerializedEntity setContent(Object value) {
        super.setContent(value);
        return this;
    }

    @Override
    public SerializedEntity setContent(Supplier<?> value) {
        super.setContent(value);
        return this;
    }

    @Override
    public SerializedEntity setContentEncoding(ContentEncoding value) {
        super.setContentEncoding(value);
        return this;
    }

    @Override
    public SerializedEntity setContentEncoding(String value) {
        super.setContentEncoding(value);
        return this;
    }

    @Override
    public SerializedEntity setContentLength(long value) {
        super.setContentLength(value);
        return this;
    }

    @Override
    public SerializedEntity setContentType(ContentType value) {
        super.setContentType(value);
        return this;
    }

    @Override
    public SerializedEntity setContentType(String value) {
        super.setContentType(value);
        return this;
    }

    @Override
    public SerializedEntity setMaxLength(int value) {
        super.setMaxLength(value);
        return this;
    }

    public SerializedEntity setSchema(HttpPartSchema value) {
        this.assertModifiable();
        this.schema = value;
        return this;
    }

    public SerializedEntity setSerializer(Serializer value) {
        this.assertModifiable();
        this.serializer = value;
        return this;
    }

    @Override
    public SerializedEntity setUnmodifiable() {
        super.setUnmodifiable();
        return this;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        block14: {
            try {
                os = new NoCloseOutputStream(os);
                Object o = this.contentOrElse(null);
                if (this.serializer == null) {
                    try (OutputStreamWriter w = new OutputStreamWriter(os, IoUtils.UTF8);){
                        w.write(o.toString());
                        break block14;
                    }
                }
                SerializerSession session = this.serializer.createSession().schema(this.schema).build();
                try (Closeable c = session.isWriterSerializer() ? new OutputStreamWriter(os, IoUtils.UTF8) : os;){
                    session.serialize(o, c);
                }
            }
            catch (SerializeException e) {
                throw ThrowableUtils.rex(e, "Serialization error on request body.", new Object[0]);
            }
        }
    }
}

