/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.junit.bct;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.junit.bct.BeanConverter;
import org.apache.juneau.junit.bct.Stringifier;

public class Stringifiers {
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();

    public static Stringifier<byte[]> byteArrayStringifier() {
        return (bc, bytes) -> {
            StringBuilder sb = new StringBuilder(((byte[])bytes).length * 2);
            for (byte element : bytes) {
                int v = element & 0xFF;
                sb.append(HEX[v >>> 4]).append(HEX[v & 0xF]);
            }
            return sb.toString();
        };
    }

    public static Stringifier<GregorianCalendar> calendarStringifier() {
        return (bc, calendar) -> calendar.toZonedDateTime().format(bc.getSetting("calendarFormat", DateTimeFormatter.ISO_INSTANT));
    }

    public static Stringifier<char[]> charArrayStringifier() {
        return (bc, chars) -> new String((char[])chars);
    }

    public static Stringifier<Class> classStringifier() {
        return Stringifiers::stringifyClass;
    }

    public static Stringifier<Constructor> constructorStringifier() {
        return (bc, constructor) -> Stringifiers.stringifyClass(bc, constructor.getDeclaringClass()) + '(' + Arrays.stream(constructor.getParameterTypes()).map(x -> Stringifiers.stringifyClass(bc, x)).collect(Collectors.joining(",")) + ')';
    }

    public static Stringifier<Date> dateStringifier() {
        return (bc, date) -> date.toInstant().toString();
    }

    public static Stringifier<Enum> enumStringifier() {
        return (bc, enumValue) -> enumValue.name();
    }

    public static Stringifier<File> fileStringifier() {
        return (bc, file) -> Utils.safe(() -> Stringifiers.stringifyReader(Files.newBufferedReader(file.toPath())));
    }

    public static Stringifier<InputStream> inputStreamStringifier() {
        return (bc, stream) -> Stringifiers.stringifyInputStream(stream);
    }

    public static Stringifier<List> listStringifier() {
        return (bc, list) -> list.stream().map(bc::stringify).collect(Collectors.joining(bc.getSetting("fieldSeparator", ","), bc.getSetting("collectionPrefix", "["), bc.getSetting("collectionSuffix", "]")));
    }

    public static Stringifier<Map.Entry> mapEntryStringifier() {
        return (bc, entry) -> bc.stringify(entry.getKey()) + bc.getSetting("mapEntrySeparator", "=") + bc.stringify(entry.getValue());
    }

    public static Stringifier<Map> mapStringifier() {
        return (bc, map) -> map.entrySet().stream().map(bc::stringify).collect(Collectors.joining(bc.getSetting("fieldSeparator", ","), bc.getSetting("mapPrefix", "{"), bc.getSetting("mapSuffix", "}")));
    }

    public static Stringifier<Method> methodStringifier() {
        return (bc, method) -> method.getName() + '(' + Arrays.stream(method.getParameterTypes()).map(x -> Stringifiers.stringifyClass(bc, x)).collect(Collectors.joining(",")) + ')';
    }

    public static Stringifier<Reader> readerStringifier() {
        return (bc, reader) -> Stringifiers.stringifyReader(reader);
    }

    private static String stringifyClass(BeanConverter bc, Class<?> clazz) {
        return switch (bc.getSetting("classNameFormat", "default")) {
            case "simple" -> Utils.cns(clazz);
            case "canonical" -> clazz.getCanonicalName();
            default -> Utils.cn(clazz);
        };
    }

    private static String stringifyInputStream(InputStream stream) {
        return Utils.safe(() -> {
            try (InputStream o2 = stream;){
                ByteArrayOutputStream buff = new ByteArrayOutputStream(1024);
                int nRead = 0;
                byte[] b = new byte[1024];
                while ((nRead = o2.read(b, 0, b.length)) != -1) {
                    buff.write(b, 0, nRead);
                }
                buff.flush();
                byte[] bytes = buff.toByteArray();
                StringBuilder sb = new StringBuilder(bytes.length * 2);
                for (byte element : bytes) {
                    int v = element & 0xFF;
                    sb.append(HEX[v >>> 4]).append(HEX[v & 0xF]);
                }
                String string = sb.toString();
                return string;
            }
        });
    }

    private static String stringifyReader(Reader reader) {
        return Utils.safe(() -> {
            try (Reader o2 = reader;){
                StringBuilder sb = new StringBuilder();
                char[] buf = new char[1024];
                int i = 0;
                while ((i = o2.read(buf)) != -1) {
                    sb.append(buf, 0, i);
                }
                String string = sb.toString();
                return string;
            }
        });
    }

    private Stringifiers() {
    }
}

