/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.staticfile;

import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.http.Header;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.commons.io.MimeTypeDetector;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.FileFinder;
import org.apache.juneau.http.resource.HttpResource;
import org.apache.juneau.rest.staticfile.BasicStaticFiles;

public interface StaticFiles
extends FileFinder {
    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    public Optional<HttpResource> resolve(String var1, Locale var2);

    public static class Builder
    extends BeanBuilder<StaticFiles> {
        List<Header> headers = CollectionUtils.list(new Header[0]);
        MimeTypeDetector mimeTypes;
        FileFinder.Builder fileFinder;

        protected Builder(BeanStore beanStore) {
            super(BasicStaticFiles.class, beanStore);
            this.fileFinder = FileFinder.create(beanStore);
            this.mimeTypes = MimeTypeDetector.DEFAULT;
        }

        public Builder addMimeTypes(String mimeTypes) {
            this.mimeTypes = MimeTypeDetector.builder().addTypes(mimeTypes).build();
            return this;
        }

        public Builder caching(long cachingLimit) {
            this.fileFinder.caching(cachingLimit);
            return this;
        }

        public Builder cp(Class<?> c, String path, boolean recursive) {
            this.fileFinder.cp(c, path, recursive);
            return this;
        }

        public Builder dir(String path) {
            this.fileFinder.dir(path);
            return this;
        }

        public Builder exclude(String ... patterns) {
            this.fileFinder.exclude(patterns);
            return this;
        }

        public Builder headers(Header ... headers) {
            CollectionUtils.addAll(this.headers, headers);
            return this;
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder include(String ... patterns) {
            this.fileFinder.include(patterns);
            return this;
        }

        public Builder mimeTypes(MimeTypeDetector value) {
            this.mimeTypes = value;
            return this;
        }

        public Builder path(Path value) {
            this.fileFinder.path(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }

        @Override
        protected StaticFiles buildDefault() {
            return new BasicStaticFiles(this);
        }
    }

    public static abstract class Void
    implements StaticFiles {
    }
}

