/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.message.UpdateRaftVoterRequestData;
import org.apache.kafka.common.message.UpdateRaftVoterResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.LeaderState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.RaftUtil;
import org.apache.kafka.raft.ReplicaKey;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.raft.internals.KRaftControlRecordStateMachine;
import org.apache.kafka.raft.internals.LogHistory;
import org.apache.kafka.server.common.KRaftVersion;

public final class UpdateVoterHandler {
    private final OptionalInt localId;
    private final KRaftControlRecordStateMachine partitionState;
    private final ListenerName defaultListenerName;
    private final Time time;
    private final long requestTimeoutMs;

    public UpdateVoterHandler(OptionalInt localId, KRaftControlRecordStateMachine partitionState, ListenerName defaultListenerName, Time time, long requestTimeoutMs) {
        this.localId = localId;
        this.partitionState = partitionState;
        this.defaultListenerName = defaultListenerName;
        this.time = time;
        this.requestTimeoutMs = requestTimeoutMs;
    }

    public CompletableFuture<UpdateRaftVoterResponseData> handleUpdateVoterRequest(LeaderState<?> leaderState, ListenerName requestListenerName, ReplicaKey voterKey, Endpoints voterEndpoints, UpdateRaftVoterRequestData.KRaftVersionFeature supportedKraftVersions, long currentTimeMs) {
        if (leaderState.isOperationPending(currentTimeMs)) {
            return CompletableFuture.completedFuture(RaftUtil.updateVoterResponse(Errors.REQUEST_TIMED_OUT, requestListenerName, new LeaderAndEpoch(this.localId, leaderState.epoch()), leaderState.leaderEndpoints()));
        }
        Optional<Long> highWatermark = leaderState.highWatermark().map(LogOffsetMetadata::offset);
        if (!highWatermark.isPresent()) {
            return CompletableFuture.completedFuture(RaftUtil.updateVoterResponse(Errors.REQUEST_TIMED_OUT, requestListenerName, new LeaderAndEpoch(this.localId, leaderState.epoch()), leaderState.leaderEndpoints()));
        }
        KRaftVersion kraftVersion = this.partitionState.lastKraftVersion();
        if (!kraftVersion.isReconfigSupported()) {
            return CompletableFuture.completedFuture(RaftUtil.updateVoterResponse(Errors.UNSUPPORTED_VERSION, requestListenerName, new LeaderAndEpoch(this.localId, leaderState.epoch()), leaderState.leaderEndpoints()));
        }
        Optional<LogHistory.Entry<VoterSet>> votersEntry = this.partitionState.lastVoterSetEntry();
        if (!votersEntry.isPresent() || votersEntry.get().offset() >= highWatermark.get()) {
            return CompletableFuture.completedFuture(RaftUtil.updateVoterResponse(Errors.REQUEST_TIMED_OUT, requestListenerName, new LeaderAndEpoch(this.localId, leaderState.epoch()), leaderState.leaderEndpoints()));
        }
        if (!this.validVersionRange(kraftVersion, supportedKraftVersions)) {
            return CompletableFuture.completedFuture(RaftUtil.updateVoterResponse(Errors.INVALID_REQUEST, requestListenerName, new LeaderAndEpoch(this.localId, leaderState.epoch()), leaderState.leaderEndpoints()));
        }
        if (!voterEndpoints.address(this.defaultListenerName).isPresent()) {
            return CompletableFuture.completedFuture(RaftUtil.updateVoterResponse(Errors.INVALID_REQUEST, requestListenerName, new LeaderAndEpoch(this.localId, leaderState.epoch()), leaderState.leaderEndpoints()));
        }
        Optional<VoterSet> updatedVoters = votersEntry.get().value().updateVoter(VoterSet.VoterNode.of(voterKey, voterEndpoints, new SupportedVersionRange(supportedKraftVersions.minSupportedVersion(), supportedKraftVersions.maxSupportedVersion())));
        if (!updatedVoters.isPresent()) {
            return CompletableFuture.completedFuture(RaftUtil.updateVoterResponse(Errors.VOTER_NOT_FOUND, requestListenerName, new LeaderAndEpoch(this.localId, leaderState.epoch()), leaderState.leaderEndpoints()));
        }
        leaderState.appendVotersRecord(updatedVoters.get(), currentTimeMs);
        return CompletableFuture.completedFuture(RaftUtil.updateVoterResponse(Errors.NONE, requestListenerName, new LeaderAndEpoch(this.localId, leaderState.epoch()), leaderState.leaderEndpoints()));
    }

    private boolean validVersionRange(KRaftVersion finalizedVersion, UpdateRaftVoterRequestData.KRaftVersionFeature supportedKraftVersions) {
        return supportedKraftVersions.minSupportedVersion() <= finalizedVersion.featureLevel() && supportedKraftVersions.maxSupportedVersion() >= finalizedVersion.featureLevel();
    }
}

