/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.jline;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.apache.felix.gogo.jline.BaseConverters;
import org.apache.felix.gogo.jline.Builtin;
import org.apache.felix.gogo.jline.Posix;
import org.apache.felix.gogo.jline.Procedural;
import org.apache.felix.gogo.jline.Shell;
import org.apache.felix.gogo.runtime.CommandProcessorImpl;
import org.apache.felix.gogo.runtime.CommandSessionImpl;
import org.apache.felix.gogo.runtime.threadio.ThreadIOImpl;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        try (Terminal terminal = TerminalBuilder.builder().name("gogo").system(true).nativeSignals(true).signalHandler(Terminal.SignalHandler.SIG_IGN).build();){
            ThreadIOImpl tio = new ThreadIOImpl();
            tio.start();
            try {
                CommandProcessorImpl processor = new CommandProcessorImpl(tio);
                MyContext context = new MyContext();
                Shell shell = new Shell(context, processor, tio, null);
                processor.addCommand("gogo", (Object)processor, "addCommand");
                processor.addCommand("gogo", (Object)processor, "removeCommand");
                processor.addCommand("gogo", (Object)processor, "eval");
                processor.addConverter(new BaseConverters());
                Main.register(processor, new Builtin(), Builtin.functions);
                Main.register(processor, new Procedural(), Procedural.functions);
                Main.register(processor, new Posix(processor), Posix.functions);
                Main.register(processor, shell, Shell.functions);
                FilterInputStream in = new FilterInputStream(terminal.input()){

                    @Override
                    public void close() {
                    }
                };
                FilterOutputStream out = new FilterOutputStream(terminal.output()){

                    @Override
                    public void close() {
                    }
                };
                CommandSessionImpl session = processor.createSession(in, out, out);
                session.put(".context", context);
                session.put(".terminal", terminal);
                try {
                    String[] argv = new String[args.length + 1];
                    argv[0] = "--login";
                    System.arraycopy(args, 0, argv, 1, args.length);
                    shell.gosh(session, argv);
                }
                catch (Exception e) {
                    Object loc = session.get(".location");
                    if (null == loc || !loc.toString().contains(":")) {
                        loc = "gogo";
                    }
                    System.err.println(loc + ": " + e.getClass().getSimpleName() + ": " + e.getMessage());
                    e.printStackTrace();
                }
                finally {
                    session.close();
                }
            }
            finally {
                tio.stop();
            }
        }
    }

    static void register(CommandProcessorImpl processor, Object target, String[] functions) {
        for (String function : functions) {
            processor.addCommand("gogo", target, function);
        }
    }

    private static class MyContext
    implements Shell.Context {
        private MyContext() {
        }

        @Override
        public String getProperty(String name) {
            return System.getProperty(name);
        }

        @Override
        public void exit() {
            System.exit(0);
        }
    }
}

