/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.felix.utils.manifest.Attribute;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Directive;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.bundle.command.BundlesCommand;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.support.ShellUtil;
import org.apache.karaf.shell.support.ansi.SimpleAnsi;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWiring;

@Command(scope="bundle", name="headers", description="Displays OSGi headers of a given bundles.")
@Service
public class Headers
extends BundlesCommand {
    protected static final String KARAF_PREFIX = "Karaf-";
    protected static final String BUNDLE_PREFIX = "Bundle-";
    protected static final String PACKAGE_SUFFFIX = "-Package";
    protected static final String SERVICE_SUFFIX = "-Service";
    protected static final String CAPABILITY_SUFFIX = "-Capability";
    protected static final String IMPORT_PACKAGES_ATTRIB = "Import-Package";
    protected static final String REQUIRE_BUNDLE_ATTRIB = "Require-Bundle";
    @Option(name="--indent", description="Indentation method")
    int indent = -1;
    @Option(name="--no-uses", description="Print or not the Export-Package uses section")
    boolean noUses = false;
    @Reference(optional=true)
    Terminal terminal;

    @Override
    protected void executeOnBundle(Bundle bundle) throws Exception {
        String title = ShellUtil.getBundleName((Bundle)bundle);
        System.out.println("\n" + title);
        System.out.println(ShellUtil.getUnderlineString((String)title));
        if (this.indent == 0) {
            Dictionary dict = bundle.getHeaders();
            Enumeration keys = dict.keys();
            while (keys.hasMoreElements()) {
                Object k = keys.nextElement();
                Object v = dict.get(k);
                System.out.println(String.valueOf(k) + " = " + ShellUtil.getValueString(v));
            }
        } else {
            System.out.println(this.generateFormattedOutput(bundle));
        }
    }

    protected String generateFormattedOutput(Bundle bundle) {
        StringBuilder output = new StringBuilder();
        TreeMap otherAttribs = new TreeMap();
        TreeMap karafAttribs = new TreeMap();
        TreeMap bundleAttribs = new TreeMap();
        TreeMap serviceAttribs = new TreeMap();
        TreeMap packagesAttribs = new TreeMap();
        Dictionary dict = bundle.getHeaders();
        Enumeration keys = dict.keys();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            Object v = dict.get(k);
            if (k.startsWith(KARAF_PREFIX)) {
                karafAttribs.put(k, v);
                continue;
            }
            if (k.startsWith(BUNDLE_PREFIX)) {
                bundleAttribs.put(k, v);
                continue;
            }
            if (k.endsWith(SERVICE_SUFFIX) || k.endsWith(CAPABILITY_SUFFIX)) {
                serviceAttribs.put(k, v);
                continue;
            }
            if (k.endsWith(PACKAGE_SUFFFIX)) {
                packagesAttribs.put(k, v);
                continue;
            }
            if (k.endsWith(REQUIRE_BUNDLE_ATTRIB)) {
                packagesAttribs.put(k, v);
                continue;
            }
            otherAttribs.put(k, v);
        }
        for (Map.Entry e : otherAttribs.entrySet()) {
            output.append(String.format("%s = %s\n", e.getKey(), ShellUtil.getValueString(e.getValue())));
        }
        if (otherAttribs.size() > 0) {
            output.append('\n');
        }
        for (Map.Entry e : karafAttribs.entrySet()) {
            output.append(String.format("%s = %s\n", e.getKey(), ShellUtil.getValueString(e.getValue())));
        }
        if (karafAttribs.size() > 0) {
            output.append('\n');
        }
        for (Map.Entry e : bundleAttribs.entrySet()) {
            output.append(String.format("%s = %s\n", e.getKey(), ShellUtil.getValueString(e.getValue())));
        }
        if (bundleAttribs.size() > 0) {
            output.append('\n');
        }
        for (Map.Entry e : serviceAttribs.entrySet()) {
            output.append((String)e.getKey());
            output.append(" = \n");
            this.formatHeader(ShellUtil.getValueString(e.getValue()), null, output, this.indent);
            output.append("\n");
        }
        if (serviceAttribs.size() > 0) {
            output.append('\n');
        }
        HashMap<String, ClauseFormatter> formatters = new HashMap<String, ClauseFormatter>();
        formatters.put(REQUIRE_BUNDLE_ATTRIB, new ClauseFormatter(){

            @Override
            public void pre(Clause clause, StringBuilder output) {
                boolean isSatisfied = Headers.this.checkBundle(clause.getName(), clause.getAttribute("bundle-version"));
                output.append(isSatisfied ? SimpleAnsi.COLOR_DEFAULT : SimpleAnsi.COLOR_RED);
            }

            @Override
            public void post(Clause clause, StringBuilder output) {
                output.append(SimpleAnsi.RESET);
            }
        });
        formatters.put(IMPORT_PACKAGES_ATTRIB, new ClauseFormatter(){

            @Override
            public void pre(Clause clause, StringBuilder output) {
                boolean isSatisfied = Headers.this.checkPackage(clause.getName(), clause.getAttribute("version"));
                boolean isOptional = "optional".equals(clause.getDirective("resolution"));
                output.append(isSatisfied ? SimpleAnsi.COLOR_DEFAULT : SimpleAnsi.COLOR_RED);
                output.append(isSatisfied || isOptional ? SimpleAnsi.INTENSITY_NORMAL : SimpleAnsi.INTENSITY_BOLD);
            }

            @Override
            public void post(Clause clause, StringBuilder output) {
                output.append(SimpleAnsi.RESET);
            }
        });
        for (Map.Entry e : packagesAttribs.entrySet()) {
            output.append((String)e.getKey());
            output.append(" = \n");
            this.formatHeader(ShellUtil.getValueString(e.getValue()), (ClauseFormatter)formatters.get(e.getKey()), output, this.indent);
            output.append("\n");
        }
        if (packagesAttribs.size() > 0) {
            output.append('\n');
        }
        return output.toString();
    }

    protected void formatHeader(String header, ClauseFormatter formatter, StringBuilder builder, int indent) {
        Clause[] clauses = Parser.parseHeader(header);
        this.formatClauses(clauses, formatter, builder, indent);
    }

    protected void formatClauses(Clause[] clauses, ClauseFormatter formatter, StringBuilder builder, int indent) {
        boolean first = true;
        for (Clause clause : clauses) {
            if (first) {
                first = false;
            } else {
                builder.append(",\n");
            }
            this.formatClause(clause, formatter, builder, indent);
        }
    }

    protected void formatClause(Clause clause, ClauseFormatter formatter, StringBuilder builder, int indent) {
        builder.append("\t");
        if (formatter != null) {
            formatter.pre(clause, builder);
        }
        this.formatClause(clause, builder, indent);
        if (formatter != null) {
            formatter.post(clause, builder);
        }
    }

    protected int getTermWidth() {
        return this.terminal != null ? this.terminal.getWidth() : 0;
    }

    protected void formatClause(Clause clause, StringBuilder builder, int indent) {
        String v;
        int i;
        if (indent < 0) {
            indent = clause.toString().length() < this.getTermWidth() - 8 ? 1 : 3;
        }
        String name = clause.getName();
        Directive[] directives = clause.getDirectives();
        Attribute[] attributes = clause.getAttributes();
        Arrays.sort(directives, Comparator.comparing(Directive::getName));
        Arrays.sort(attributes, Comparator.comparing(Attribute::getName));
        builder.append(name);
        for (i = 0; directives != null && i < directives.length; ++i) {
            if (this.noUses && directives[i].getName().equalsIgnoreCase("uses")) continue;
            builder.append(";");
            if (indent > 1) {
                builder.append("\n\t\t");
            }
            builder.append(directives[i].getName()).append(":=");
            v = directives[i].getValue();
            if (v.contains(",")) {
                if (indent > 2 && v.length() > 20) {
                    v = v.replace(",", ",\n\t\t\t");
                }
                builder.append("\"").append(v).append("\"");
                continue;
            }
            builder.append(v);
        }
        for (i = 0; attributes != null && i < attributes.length; ++i) {
            builder.append(";");
            if (indent > 1) {
                builder.append("\n\t\t");
            }
            builder.append(attributes[i].getName()).append("=");
            v = attributes[i].getValue();
            if (v.contains(",")) {
                if (indent > 2 && v.length() > 20) {
                    v = v.replace(",", ",\n\t\t\t");
                }
                builder.append("\"").append(v).append("\"");
                continue;
            }
            builder.append(v);
        }
    }

    private boolean checkBundle(String bundleName, String version) {
        VersionRange vr = VersionRange.parseVersionRange(version);
        Bundle[] bundles = this.bundleContext.getBundles();
        for (int i = 0; bundles != null && i < bundles.length; ++i) {
            String sym = bundles[i].getSymbolicName();
            if (sym == null || !sym.equals(bundleName) || !vr.contains(bundles[i].getVersion())) continue;
            return true;
        }
        return false;
    }

    private boolean checkPackage(String packageName, String version) {
        VersionRange range = VersionRange.parseVersionRange(version);
        Bundle[] bundles = this.bundleContext.getBundles();
        for (int i = 0; bundles != null && i < bundles.length; ++i) {
            List caps;
            BundleWiring wiring = (BundleWiring)bundles[i].adapt(BundleWiring.class);
            List list = caps = wiring != null ? wiring.getCapabilities("osgi.wiring.package") : null;
            if (caps == null) continue;
            for (BundleCapability cap : caps) {
                String n = this.getAttribute(cap, "osgi.wiring.package");
                String v = this.getAttribute(cap, "version");
                if (!packageName.equals(n) || !range.contains(VersionTable.getVersion(v))) continue;
                return true;
            }
        }
        return false;
    }

    private String getAttribute(BundleCapability cap, String name) {
        Object obj = cap.getAttributes().get(name);
        return obj != null ? obj.toString() : null;
    }

    protected static interface ClauseFormatter {
        public void pre(Clause var1, StringBuilder var2);

        public void post(Clause var1, StringBuilder var2);
    }
}

