/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.cli.converters;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.kyuubi.shade.io.vertx.core.cli.converters.Converter;

public final class ConstructorBasedConverter<T>
implements Converter<T> {
    private final Constructor<T> constructor;

    private ConstructorBasedConverter(Constructor<T> constructor) {
        this.constructor = constructor;
    }

    public static <T> ConstructorBasedConverter<T> getIfEligible(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getConstructor(String.class);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return new ConstructorBasedConverter<T>(constructor);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Override
    public T fromString(String input) throws IllegalArgumentException {
        try {
            return this.constructor.newInstance(input);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            if (e.getCause() != null) {
                throw new IllegalArgumentException(e.getCause());
            }
            throw new IllegalArgumentException(e);
        }
    }
}

