/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.trino;

import com.google.common.base.Verify;
import io.trino.client.ClientSession;
import io.trino.client.ClientTypeSignature;
import io.trino.client.Column;
import io.trino.client.QueryStatusInfo;
import io.trino.client.StatementClient;
import io.trino.client.StatementClientFactory;
import java.io.Serializable;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.trino.TrinoConf$;
import org.apache.kyuubi.engine.trino.TrinoContext;
import org.apache.kyuubi.engine.trino.TrinoStatement$;
import org.apache.kyuubi.engine.trino.TrinoStatusPrinter$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.MapLike;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001\u0002\u0011\"\u00011B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u001d\u0011\u0007A1A\u0005\n\rDaA\u001e\u0001!\u0002\u0013!\u0007\u0002\u0003\u0012\u0001\u0011\u000b\u0007I\u0011B<\t\u0011m\u0004\u0001R1A\u0005\nqD!\"!\u0001\u0001\u0011\u000b\u0007I\u0011BA\u0002\u0011)\tY\u0001\u0001EC\u0002\u0013%\u00111\u0001\u0005\n\u0003\u001b\u0001!\u0019!C\u0005\u0003\u001fA\u0001\"!\n\u0001A\u0003%\u0011\u0011\u0003\u0005\n\u0003O\u0001\u0001\u0019!C\u0005\u0003SA\u0011\"a\r\u0001\u0001\u0004%I!!\u000e\t\u0011\u0005\u0005\u0003\u0001)Q\u0005\u0003WA\u0011\"a\u0011\u0001\u0005\u0004%\u0019!!\u0012\t\u0011\u0005E\u0003\u0001)A\u0005\u0003\u000fBa!a\u0015\u0001\t\u00039\bbBA+\u0001\u0011\u0005\u0011q\u000b\u0005\b\u00033\u0002A\u0011AA,\u0011\u0019\tY\u0006\u0001C\u0001G\"9\u0011Q\f\u0001\u0005\u0002\u0005}\u0003bBA8\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003g\u0002A\u0011AA9\u0011\u001d\t)\b\u0001C\u0001\u0003c:q!a\u001e\"\u0011\u0003\tIH\u0002\u0004!C!\u0005\u00111\u0010\u0005\u00077r!\t!! \t\u000f\u0005}D\u0004\"\u0001\u0002\u0002\"I\u00111\u0012\u000f\u0012\u0002\u0013\u0005\u0011Q\u0012\u0002\u000f)JLgn\\*uCR,W.\u001a8u\u0015\t\u00113%A\u0003ue&twN\u0003\u0002%K\u00051QM\\4j]\u0016T!AJ\u0014\u0002\r-LX/\u001e2j\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g!\t!T'D\u0001&\u0013\t1TEA\u0004M_\u001e<\u0017N\\4\u0002\u0019Q\u0014\u0018N\\8D_:$X\r\u001f;\u0011\u0005eRT\"A\u0011\n\u0005m\n#\u0001\u0004+sS:|7i\u001c8uKb$\u0018AC6zkV\u0014\u0017nQ8oMB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001)J\u0001\u0007G>tg-[4\n\u0005\t{$AC&zkV\u0014\u0017nQ8oM\u0006\u00191/\u001d7\u0011\u0005\u0015ceB\u0001$K!\t9u&D\u0001I\u0015\tI5&\u0001\u0004=e>|GOP\u0005\u0003\u0017>\na\u0001\u0015:fI\u00164\u0017BA'O\u0005\u0019\u0019FO]5oO*\u00111jL\u0001\r_B,'/\u0019;j_:dun\u001a\t\u0004]E\u001b\u0016B\u0001*0\u0005\u0019y\u0005\u000f^5p]B\u0011A+W\u0007\u0002+*\u0011akV\u0001\u0004Y><'B\u0001-&\u0003%y\u0007/\u001a:bi&|g.\u0003\u0002[+\naq\n]3sCRLwN\u001c'pO\u00061A(\u001b8jiz\"R!\u00180`A\u0006\u0004\"!\u000f\u0001\t\u000b]*\u0001\u0019\u0001\u001d\t\u000bq*\u0001\u0019A\u001f\t\u000b\r+\u0001\u0019\u0001#\t\u000b=+\u0001\u0019\u0001)\u0002\u001b\u0011,g-Y;miN\u001b\u0007.Z7b+\u0005!\u0007cA3k[:\u0011a\r\u001b\b\u0003\u000f\u001eL\u0011\u0001M\u0005\u0003S>\nq\u0001]1dW\u0006<W-\u0003\u0002lY\n!A*[:u\u0015\tIw\u0006\u0005\u0002oi6\tqN\u0003\u0002qc\u000611\r\\5f]RT!A\t:\u000b\u0003M\f!![8\n\u0005U|'AB\"pYVlg.\u0001\beK\u001a\fW\u000f\u001c;TG\",W.\u0019\u0011\u0016\u0003a\u0004\"A\\=\n\u0005i|'aD*uCR,W.\u001a8u\u00072LWM\u001c;\u0002-\u0011\fG/\u0019)s_\u000e,7o]5oOB{w\u000e\\*ju\u0016,\u0012! \t\u0003]yL!a`\u0018\u0003\u0007%sG/A\u0006tQ><\bK]8dKN\u001cXCAA\u0003!\rq\u0013qA\u0005\u0004\u0003\u0013y#a\u0002\"p_2,\u0017M\\\u0001\ng\"|w\u000fR3ck\u001e\fQ\u0001^5nKJ,\"!!\u0005\u0011\t\u0005M\u0011\u0011E\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005m\u0011QD\u0001\u0005kRLGN\u0003\u0002\u0002 \u0005!!.\u0019<b\u0013\u0011\t\u0019#!\u0006\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW-\u0001\u0004uS6,'\u000fI\u0001\nY\u0006\u001cHo\u0015;biN,\"!a\u000b\u0011\t\u00055\u0012qF\u0007\u0003\u00033IA!!\r\u0002\u001a\tqq\n\u001d;j_:\fG\u000eR8vE2,\u0017!\u00047bgR\u001cF/\u0019;t?\u0012*\u0017\u000f\u0006\u0003\u00028\u0005u\u0002c\u0001\u0018\u0002:%\u0019\u00111H\u0018\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u007fy\u0011\u0011!a\u0001\u0003W\t1\u0001\u001f\u00132\u0003)a\u0017m\u001d;Ti\u0006$8\u000fI\u0001\u0003K\u000e,\"!a\u0012\u0011\t\u0005%\u0013QJ\u0007\u0003\u0003\u0017R1!a\u00060\u0013\u0011\ty%a\u0013\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA3dA\u0005qq-\u001a;Ue&twn\u00117jK:$\u0018!E4fi\u000e+(O]3oi\u000e\u000bG/\u00197pOV\tA)\u0001\nhKR\u001cUO\u001d:f]R$\u0015\r^1cCN,\u0017AC4fi\u000e{G.^7og\u00069Q\r_3dkR,GCAA1!\u0015)\u00171MA4\u0013\r\t)\u0007\u001c\u0002\t\u0013R,'/\u0019;peB!QM[A5!\rq\u00131N\u0005\u0004\u0003[z#aA!os\u0006\u0011R\u000f\u001d3bi\u0016$&/\u001b8p\u0007>tG/\u001a=u)\t\t9$A\bqe&tGo\u0015;biV\u001c\u0018J\u001c4p\u0003-\u0019Ho\u001c9Qe&tG/\u001a:\u0002\u001dQ\u0013\u0018N\\8Ti\u0006$X-\\3oiB\u0011\u0011\bH\n\u000395\"\"!!\u001f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013u\u000b\u0019)!\"\u0002\b\u0006%\u0005\"B\u001c\u001f\u0001\u0004A\u0004\"\u0002\u001f\u001f\u0001\u0004i\u0004\"B\"\u001f\u0001\u0004!\u0005bB(\u001f!\u0003\u0005\r\u0001U\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\u0012\u0016\u0004!\u0006E5FAAJ!\u0011\t)*a(\u000e\u0005\u0005]%\u0002BAM\u00037\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005uu&\u0001\u0006b]:|G/\u0019;j_:LA!!)\u0002\u0018\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class TrinoStatement
implements Logging {
    private StatementClient trino;
    private int dataProcessingPoolSize;
    private boolean showProcess;
    private boolean showDebug;
    private final TrinoContext trinoContext;
    private final KyuubiConf kyuubiConf;
    private String sql;
    private final Option<OperationLog> operationLog;
    private final List<Column> defaultSchema;
    private final ScheduledExecutorService timer;
    private OptionalDouble lastStats;
    private final ExecutionContext ec;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile byte bitmap$0;

    public static Option<OperationLog> apply$default$4() {
        return TrinoStatement$.MODULE$.apply$default$4();
    }

    public static TrinoStatement apply(TrinoContext trinoContext, KyuubiConf kyuubiConf, String string, Option<OperationLog> option) {
        return TrinoStatement$.MODULE$.apply(trinoContext, kyuubiConf, string, option);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private List<Column> defaultSchema() {
        return this.defaultSchema;
    }

    private StatementClient trino$lzycompute() {
        TrinoStatement trinoStatement = this;
        synchronized (trinoStatement) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.trino = StatementClientFactory.newStatementClient((OkHttpClient)this.trinoContext.httpClient(), (ClientSession)this.trinoContext.clientSession().get(), (String)this.sql);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.sql = null;
        return this.trino;
    }

    private StatementClient trino() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.trino$lzycompute();
        }
        return this.trino;
    }

    private int dataProcessingPoolSize$lzycompute() {
        TrinoStatement trinoStatement = this;
        synchronized (trinoStatement) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dataProcessingPoolSize = BoxesRunTime.unboxToInt((Object)this.kyuubiConf.get(TrinoConf$.MODULE$.DATA_PROCESSING_POOL_SIZE()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dataProcessingPoolSize;
    }

    private int dataProcessingPoolSize() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.dataProcessingPoolSize$lzycompute();
        }
        return this.dataProcessingPoolSize;
    }

    private boolean showProcess$lzycompute() {
        TrinoStatement trinoStatement = this;
        synchronized (trinoStatement) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.showProcess = BoxesRunTime.unboxToBoolean((Object)this.kyuubiConf.get(KyuubiConf$.MODULE$.ENGINE_TRINO_SHOW_PROGRESS()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.showProcess;
    }

    private boolean showProcess() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.showProcess$lzycompute();
        }
        return this.showProcess;
    }

    private boolean showDebug$lzycompute() {
        TrinoStatement trinoStatement = this;
        synchronized (trinoStatement) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.showDebug = BoxesRunTime.unboxToBoolean((Object)this.kyuubiConf.get(KyuubiConf$.MODULE$.ENGINE_TRINO_SHOW_PROGRESS_DEBUG()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.showDebug;
    }

    private boolean showDebug() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.showDebug$lzycompute();
        }
        return this.showDebug;
    }

    private ScheduledExecutorService timer() {
        return this.timer;
    }

    private OptionalDouble lastStats() {
        return this.lastStats;
    }

    private void lastStats_$eq(OptionalDouble x$1) {
        this.lastStats = x$1;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public StatementClient getTrinoClient() {
        return this.trino();
    }

    public String getCurrentCatalog() {
        return this.trinoContext.clientSession().get().getCatalog();
    }

    public String getCurrentDatabase() {
        return this.trinoContext.clientSession().get().getSchema();
    }

    public List<Column> getColumns() {
        while (this.trino().isRunning()) {
            QueryStatusInfo results = this.trino().currentStatusInfo();
            java.util.List columns = results.getColumns();
            if (columns != null) {
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Execute with Trino query id: ").append(results.getId()).toString());
                if (columns.isEmpty()) {
                    return this.defaultSchema();
                }
                return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(columns).asScala()).toList();
            }
            this.trino().advance();
        }
        Verify.verify((boolean)this.trino().isFinished());
        QueryStatusInfo finalStatus = this.trino().finalStatusInfo();
        if (finalStatus.getError() == null) {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(24).append("Query has no columns (#").append(finalStatus.getId()).append(")").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(18).append("Query failed (#").append(finalStatus.getId()).append("): ").append(finalStatus.getError().getMessage()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
    }

    public Iterator<List<Object>> execute() {
        return package$.MODULE$.Iterator().continually((Function0 & Serializable & scala.Serializable)() -> this.getData$1()).takeWhile((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2._1$mcZ$sp())).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (List)x$3._2());
    }

    public void updateTrinoContext() {
        ClientSession session = this.trinoContext.clientSession().get();
        ClientSession.Builder builder = ClientSession.builder((ClientSession)session);
        if (this.trino().getSetCatalog().isPresent() || this.trino().getSetSchema().isPresent()) {
            builder = builder.catalog(this.trino().getSetCatalog().orElse(session.getCatalog())).schema(this.trino().getSetSchema().orElse(session.getSchema()));
        }
        if (this.trino().getSetPath().isPresent()) {
            builder = builder.path((String)this.trino().getSetPath().get());
        }
        if (!this.trino().getSetSessionProperties().isEmpty() || !this.trino().getResetSessionProperties().isEmpty()) {
            scala.collection.mutable.Map properties = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(session.getProperties()).asScala()).clone();
            properties.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.trino().getSetSessionProperties()).asScala());
            properties.$minus$minus$eq((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.trino().getResetSessionProperties()).asScala());
            builder = builder.properties((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(properties).asJava());
        }
        this.trinoContext.clientSession().set(builder.build());
    }

    public void printStatusInfo() {
        if (this.operationLog.isDefined() && this.showProcess()) {
            this.timer().scheduleWithFixedDelay(() -> {
                if (this.trino().isRunning()) {
                    this.lastStats_$eq(TrinoStatusPrinter$.MODULE$.printStatusInfo(this.trino(), (OperationLog)$this.operationLog.get(), this.showDebug(), this.lastStats()));
                    return;
                }
            }, 500L, BoxesRunTime.unboxToLong((Object)this.kyuubiConf.get(KyuubiConf$.MODULE$.ENGINE_TRINO_SHOW_PROGRESS_UPDATE_INTERVAL())), TimeUnit.MILLISECONDS);
            return;
        }
    }

    public void stopPrinter() {
        this.timer().shutdown();
    }

    private final Tuple2 getData$1() {
        while (this.trino().isRunning()) {
            Iterable data = this.trino().currentData().getData();
            this.trino().advance();
            if (data == null) continue;
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(data).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$1 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).toList(), List$.MODULE$.canBuildFrom()));
        }
        this.timer().shutdown();
        Verify.verify((boolean)this.trino().isFinished());
        Object object = this.operationLog.isDefined() && this.showProcess() ? TrinoStatusPrinter$.MODULE$.printStatusInfo(this.trino(), (OperationLog)this.operationLog.get(), this.showDebug(), TrinoStatusPrinter$.MODULE$.printStatusInfo$default$4()) : BoxedUnit.UNIT;
        QueryStatusInfo finalStatus = this.trino().finalStatusInfo();
        if (finalStatus.getError() != null) {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(15).append("Query ").append(finalStatus.getId()).append(" failed: ").append(finalStatus.getError().getMessage()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        this.updateTrinoContext();
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Nil$.MODULE$);
    }

    public TrinoStatement(TrinoContext trinoContext, KyuubiConf kyuubiConf, String sql, Option<OperationLog> operationLog) {
        this.trinoContext = trinoContext;
        this.kyuubiConf = kyuubiConf;
        this.sql = sql;
        this.operationLog = operationLog;
        Logging.$init$((Logging)this);
        this.defaultSchema = new .colon.colon((Object)new Column("Result", "VARCHAR", new ClientTypeSignature("VARCHAR")), (List)Nil$.MODULE$);
        this.timer = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("Trino-Status-Printer", false);
        this.lastStats = OptionalDouble.empty();
        this.ec = ExecutionContext$.MODULE$.fromExecutor((Executor)Executors.newFixedThreadPool(this.dataProcessingPoolSize()));
    }
}

