/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.hive.service.auth;

import javax.security.sasl.AuthenticationException;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.conf.HiveConf;
import org.apache.kyuubi.shade.org.apache.hive.service.auth.AnonymousAuthenticationProviderImpl;
import org.apache.kyuubi.shade.org.apache.hive.service.auth.CustomAuthenticationProviderImpl;
import org.apache.kyuubi.shade.org.apache.hive.service.auth.LdapAuthenticationProviderImpl;
import org.apache.kyuubi.shade.org.apache.hive.service.auth.PamAuthenticationProviderImpl;
import org.apache.kyuubi.shade.org.apache.hive.service.auth.PasswdAuthenticationProvider;

public final class AuthenticationProviderFactory {
    private AuthenticationProviderFactory() {
    }

    public static PasswdAuthenticationProvider getAuthenticationProvider(AuthMethods authMethod) throws AuthenticationException {
        return AuthenticationProviderFactory.getAuthenticationProvider(authMethod, new HiveConf());
    }

    public static PasswdAuthenticationProvider getAuthenticationProvider(AuthMethods authMethod, HiveConf conf) throws AuthenticationException {
        if (authMethod == AuthMethods.LDAP) {
            return new LdapAuthenticationProviderImpl(conf);
        }
        if (authMethod == AuthMethods.PAM) {
            return new PamAuthenticationProviderImpl(conf);
        }
        if (authMethod == AuthMethods.CUSTOM) {
            return new CustomAuthenticationProviderImpl(conf);
        }
        if (authMethod == AuthMethods.NONE) {
            return new AnonymousAuthenticationProviderImpl();
        }
        throw new AuthenticationException("Unsupported authentication method");
    }

    public static enum AuthMethods {
        LDAP("LDAP"),
        PAM("PAM"),
        CUSTOM("CUSTOM"),
        NONE("NONE");

        private final String authMethod;

        private AuthMethods(String authMethod) {
            this.authMethod = authMethod;
        }

        public String getAuthMethod() {
            return this.authMethod;
        }

        public static AuthMethods getValidAuthMethod(String authMethodStr) throws AuthenticationException {
            for (AuthMethods auth : AuthMethods.values()) {
                if (!authMethodStr.equals(auth.getAuthMethod())) continue;
                return auth;
            }
            throw new AuthenticationException("Not a valid authentication method");
        }
    }
}

