/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark.session;

import java.io.Serializable;
import java.nio.file.Path;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ShareLevel$;
import org.apache.kyuubi.engine.spark.SparkSQLEngine$;
import org.apache.kyuubi.engine.spark.operation.SparkSQLOperationManager;
import org.apache.kyuubi.engine.spark.session.SparkSessionImpl;
import org.apache.kyuubi.engine.spark.udf.KDFRegistry$;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionManager;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001\u0002\b\u0010\u0001qA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\t%\u0001\u0011\t\u0011)A\u0005a!)q\u0007\u0001C\u0005q!)q\u0007\u0001C\u0001{!)q\b\u0001C!\u0001\"9Q\n\u0001b\u0001\n\u0003q\u0005BB+\u0001A\u0003%q\n\u0003\u0005W\u0001!\u0015\r\u0011\"\u0003X\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015A\b\u0001\"\u0011z\u0011\u0015a\b\u0001\"\u0003~\u0011\u001d\t9\u0001\u0001C\u0005\u0003\u0013Aa!a\u0003\u0001\t#:&AF*qCJ\\7+\u0015'TKN\u001c\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005A\t\u0012aB:fgNLwN\u001c\u0006\u0003%M\tQa\u001d9be.T!\u0001F\u000b\u0002\r\u0015tw-\u001b8f\u0015\t1r#\u0001\u0004lsV,(-\u001b\u0006\u00031e\ta!\u00199bG\",'\"\u0001\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001i\u0002C\u0001\u0010!\u001b\u0005y\"B\u0001\t\u0016\u0013\t\tsD\u0001\bTKN\u001c\u0018n\u001c8NC:\fw-\u001a:\u0002\t9\fW.\u001a\t\u0003I5r!!J\u0016\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!Z\u0012A\u0002\u001fs_>$hHC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013&\u0001\u0004Qe\u0016$WMZ\u0005\u0003]=\u0012aa\u0015;sS:<'B\u0001\u0017*!\t\tT'D\u00013\u0015\t\u0019D'A\u0002tc2T!AE\f\n\u0005Y\u0012$\u0001D*qCJ\\7+Z:tS>t\u0017A\u0002\u001fj]&$h\bF\u0002:wq\u0002\"A\u000f\u0001\u000e\u0003=AQAI\u0002A\u0002\rBQAE\u0002A\u0002A\"\"!\u000f \t\u000bI!\u0001\u0019\u0001\u0019\u0002\u0015%t\u0017\u000e^5bY&TX\r\u0006\u0002B\u000bB\u0011!iQ\u0007\u0002S%\u0011A)\u000b\u0002\u0005+:LG\u000fC\u0003G\u000b\u0001\u0007q)\u0001\u0003d_:4\u0007C\u0001%L\u001b\u0005I%B\u0001&\u0016\u0003\u0019\u0019wN\u001c4jO&\u0011A*\u0013\u0002\u000b\u0017f,XOY5D_:4\u0017\u0001E8qKJ\fG/[8o\u001b\u0006t\u0017mZ3s+\u0005y\u0005C\u0001)T\u001b\u0005\t&B\u0001*\u0012\u0003%y\u0007/\u001a:bi&|g.\u0003\u0002U#\nA2\u000b]1sWN\u000bFj\u00149fe\u0006$\u0018n\u001c8NC:\fw-\u001a:\u0002#=\u0004XM]1uS>tW*\u00198bO\u0016\u0014\b%\u0001\ntS:<G.Z*qCJ\\7+Z:tS>tW#\u0001-\u0011\u0005\tK\u0016B\u0001.*\u0005\u001d\u0011un\u001c7fC:\f1b\u001c9f]N+7o]5p]R1Q\f\u00198qeR\u0004\"A\b0\n\u0005}{\"!D*fgNLwN\u001c%b]\u0012dW\rC\u0003b\u0013\u0001\u0007!-\u0001\u0005qe>$xnY8m!\t\u0019G.D\u0001e\u0015\t)g-\u0001\u0004uQJLg\r\u001e\u0006\u0003O\"\f1A\u001d9d\u0015\tI'.A\u0004tKJ4\u0018nY3\u000b\u0005-<\u0012\u0001\u00025jm\u0016L!!\u001c3\u0003!Q\u0003&o\u001c;pG>dg+\u001a:tS>t\u0007\"B8\n\u0001\u0004\u0019\u0013\u0001B;tKJDQ!]\u0005A\u0002\r\n\u0001\u0002]1tg^|'\u000f\u001a\u0005\u0006g&\u0001\raI\u0001\nSB\fE\r\u001a:fgNDQAR\u0005A\u0002U\u0004B\u0001\n<$G%\u0011qo\f\u0002\u0004\u001b\u0006\u0004\u0018\u0001D2m_N,7+Z:tS>tGCA!{\u0011\u0015Y(\u00021\u0001^\u00035\u0019Xm]:j_:D\u0015M\u001c3mK\u0006\u00192/\u001a;N_\u0012Lg-[1cY\u0016\u001cuN\u001c4jOR)\u0011I`@\u0002\u0004!)!c\u0003a\u0001a!1\u0011\u0011A\u0006A\u0002\r\n1a[3z\u0011\u0019\t)a\u0003a\u0001G\u0005)a/\u00197vK\u0006Y1\u000f^8q'\u0016\u001c8/[8o)\u0005\t\u0015\u0001C5t'\u0016\u0014h/\u001a:")
public class SparkSQLSessionManager
extends SessionManager {
    private boolean singleSparkSession;
    private final SparkSession spark;
    private final SparkSQLOperationManager operationManager;
    private volatile boolean bitmap$0;

    @Override
    public void initialize(KyuubiConf conf) {
        Path absPath = Utils$.MODULE$.getAbsolutePathFromWork(conf.get(KyuubiConf$.MODULE$.ENGINE_OPERATION_LOG_DIR_ROOT()), Utils$.MODULE$.getAbsolutePathFromWork$default$2());
        this._operationLogRoot_$eq((Option<String>)new Some((Object)((Object)absPath.toAbsolutePath()).toString()));
        super.initialize(conf);
    }

    @Override
    public SparkSQLOperationManager operationManager() {
        return this.operationManager;
    }

    private boolean singleSparkSession$lzycompute() {
        SparkSQLSessionManager sparkSQLSessionManager = this;
        synchronized (sparkSQLSessionManager) {
            if (!this.bitmap$0) {
                this.singleSparkSession = BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_SINGLE_SPARK_SESSION()));
                this.bitmap$0 = true;
            }
        }
        return this.singleSparkSession;
    }

    private boolean singleSparkSession() {
        return !this.bitmap$0 ? this.singleSparkSession$lzycompute() : this.singleSparkSession;
    }

    @Override
    public SessionHandle openSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        SessionHandle sessionHandle;
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Opening session for ").append(user).append("@").append(ipAddress).toString());
        SparkSessionImpl sessionImpl = new SparkSessionImpl(protocol, user, password, ipAddress, conf, this);
        SessionHandle handle = sessionImpl.handle();
        try {
            SparkSession sparkSession;
            if (this.singleSparkSession()) {
                sparkSession = this.spark;
            } else {
                SparkSession ss = this.spark.newSession();
                ((IterableLike)this.conf().get(KyuubiConf$.MODULE$.ENGINE_SESSION_INITIALIZE_SQL())).foreach((Function1 & Serializable & scala.Serializable)sqlStr -> BoxesRunTime.boxToBoolean((boolean)SparkSQLSessionManager.$anonfun$openSession$2(ss, handle, sqlStr)));
                sparkSession = ss;
            }
            SparkSession sparkSession2 = sparkSession;
            sessionImpl.normalizedConf().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                SparkSQLSessionManager.$anonfun$openSession$3(this, sparkSession2, x0$1);
                return BoxedUnit.UNIT;
            });
            sessionImpl.open();
            KDFRegistry$.MODULE$.registerAll(sparkSession2);
            this.operationManager().setSparkSession(handle, sparkSession2);
            this.setSession(handle, sessionImpl);
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append(user).append("'s session with ").append(handle).append(" is opened, current opening sessions").append(" ").append(this.getOpenSessionCount()).toString());
            sessionHandle = handle;
        }
        catch (Exception e) {
            sessionImpl.close();
            throw KyuubiSQLException$.MODULE$.apply(e);
        }
        return sessionHandle;
    }

    @Override
    public void closeSession(SessionHandle sessionHandle) {
        block0: {
            super.closeSession(sessionHandle);
            this.operationManager().removeSparkSession(sessionHandle);
            String string = this.conf().get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL());
            String string2 = ShareLevel$.MODULE$.CONNECTION().toString();
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Session stopped due to shared level is Connection.");
            this.stopSession();
        }
    }

    private void setModifiableConfig(SparkSession spark, String key, String value) {
        try {
            spark.conf().set(key, value);
        }
        catch (AnalysisException e) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage());
        }
    }

    private void stopSession() {
        SparkSQLEngine$.MODULE$.currentEngine().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.stop();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean isServer() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$openSession$2(SparkSession ss$1, SessionHandle handle$1, String sqlStr) {
        ss$1.sparkContext().setJobGroup(handle$1.identifier().toString(), sqlStr, true);
        return ss$1.sql(sqlStr).isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$openSession$3(SparkSQLSessionManager $this, SparkSession sparkSession$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String database = (String)tuple2._2();
            if ("use:database".equals(string)) {
                sparkSession$1.catalog().setCurrentDatabase(database);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        $this.setModifiableConfig(sparkSession$1, key, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SparkSQLSessionManager(String name, SparkSession spark) {
        this.spark = spark;
        super(name);
        this.operationManager = new SparkSQLOperationManager();
    }

    public SparkSQLSessionManager(SparkSession spark) {
        this(SparkSQLSessionManager.class.getSimpleName(), spark);
    }
}

