/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark.shim;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.kyuubi.engine.spark.shim.CatalogShim_v2_4;
import org.apache.kyuubi.engine.spark.shim.SparkCatalogShim$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.catalog.CatalogExtension;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0007\u000f\u0001mAQ\u0001\t\u0001\u0005\u0002\u0005BQa\t\u0001\u0005B\u0011BQA\u0010\u0001\u0005\n}BQa\u0015\u0001\u0005BQCQa\u0017\u0001\u0005\nqCQa\u0017\u0001\u0005\n\u001dDQ!\u001b\u0001\u0005\n)DQ!\u001c\u0001\u0005\n9DQA\u001d\u0001\u0005\nMDQa\u001e\u0001\u0005BaDQ\u0001 \u0001\u0005BuDq!!\u0005\u0001\t#\n\u0019B\u0001\tDCR\fGn\\4TQ&lwL^\u001a`a)\u0011q\u0002E\u0001\u0005g\"LWN\u0003\u0002\u0012%\u0005)1\u000f]1sW*\u00111\u0003F\u0001\u0007K:<\u0017N\\3\u000b\u0005U1\u0012AB6zkV\u0014\u0017N\u0003\u0002\u00181\u00051\u0011\r]1dQ\u0016T\u0011!G\u0001\u0004_J<7\u0001A\n\u0003\u0001q\u0001\"!\b\u0010\u000e\u00039I!a\b\b\u0003!\r\u000bG/\u00197pONC\u0017.\\0we}#\u0014A\u0002\u001fj]&$h\bF\u0001#!\ti\u0002!A\u0006hKR\u001c\u0015\r^1m_\u001e\u001cHCA\u0013;!\r1\u0003g\r\b\u0003O5r!\u0001K\u0016\u000e\u0003%R!A\u000b\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0013!B:dC2\f\u0017B\u0001\u00180\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011\u0001L\u0005\u0003cI\u00121aU3r\u0015\tqs\u0006\u0005\u00025q5\tQG\u0003\u00027o\u0005\u00191/\u001d7\u000b\u0005E1\u0012BA\u001d6\u0005\r\u0011vn\u001e\u0005\u0006#\t\u0001\ra\u000f\t\u0003iqJ!!P\u001b\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u0015\u001d,GoQ1uC2|w\rF\u0002A\u0011&\u0003\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\u000f\r\fG/\u00197pO*\u0011Q)N\u0001\nG>tg.Z2u_JL!a\u0012\"\u0003\u001b\r\u000bG/\u00197pOBcWoZ5o\u0011\u0015\t2\u00011\u0001<\u0011\u0015Q5\u00011\u0001L\u0003-\u0019\u0017\r^1m_\u001et\u0015-\\3\u0011\u00051\u0003fBA'O!\tAs&\u0003\u0002P_\u00051\u0001K]3eK\u001aL!!\u0015*\u0003\rM#(/\u001b8h\u0015\tyu&A\u0007dCR\fGn\\4Fq&\u001cHo\u001d\u000b\u0004+fS\u0006C\u0001,X\u001b\u0005y\u0013B\u0001-0\u0005\u001d\u0011un\u001c7fC:DQ!\u0005\u0003A\u0002mBQa\u0011\u0003A\u0002-\u000b\u0011\u0003\\5ti\u0006cGNT1nKN\u0004\u0018mY3t)\ri\u0016-\u001a\t\u0004-z\u0003\u0017BA00\u0005\u0015\t%O]1z!\r1fl\u0013\u0005\u0006\u0007\u0016\u0001\rA\u0019\t\u0003\u0003\u000eL!\u0001\u001a\"\u0003%M+\b\u000f]8siNt\u0015-\\3ta\u0006\u001cWm\u001d\u0005\u0006M\u0016\u0001\r!X\u0001\u000b]\u0006lWm\u001d9bG\u0016\u001cHCA/i\u0011\u0015\u0019e\u00011\u0001A\u00035\tXo\u001c;f\u0013\u001atU-\u001a3fIR\u00111j\u001b\u0005\u0006Y\u001e\u0001\raS\u0001\u0005a\u0006\u0014H/A\rmSN$h*Y7fgB\f7-Z:XSRD\u0007+\u0019;uKJtGcA/pa\")1\t\u0003a\u0001\u0001\")\u0011\u000f\u0003a\u0001\u0017\u0006i1o\u00195f[\u0006\u0004\u0016\r\u001e;fe:\fQcZ3u'\u000eDW-\\1t/&$\b\u000eU1ui\u0016\u0014h\u000eF\u0002ukZ\u00042A\n\u0019L\u0011\u0015\u0019\u0015\u00021\u0001A\u0011\u0015\t\u0018\u00021\u0001L\u0003)9W\r^*dQ\u0016l\u0017m\u001d\u000b\u0005KeT8\u0010C\u0003\u0012\u0015\u0001\u00071\bC\u0003K\u0015\u0001\u00071\nC\u0003r\u0015\u0001\u00071*A\fhKR\u001c\u0015\r^1m_\u001e$\u0016M\u00197fg>\u0013h+[3xgRIQE`@\u0002\u0002\u0005\r\u0011q\u0001\u0005\u0006#-\u0001\ra\u000f\u0005\u0006\u0015.\u0001\ra\u0013\u0005\u0006c.\u0001\ra\u0013\u0005\u0007\u0003\u000bY\u0001\u0019A&\u0002\u0019Q\f'\r\\3QCR$XM\u001d8\t\u000f\u0005%1\u00021\u0001\u0002\f\u0005QA/\u00192mKRK\b/Z:\u0011\t1\u000biaS\u0005\u0004\u0003\u001f\u0011&aA*fi\u0006\u0019r-\u001a;D_2,XN\\:Cs\u000e\u000bG/\u00197pORYQ%!\u0006\u0002\u0018\u0005e\u00111DA\u000f\u0011\u0015\tB\u00021\u0001<\u0011\u0015QE\u00021\u0001L\u0011\u0015\tH\u00021\u0001L\u0011\u0019\t)\u0001\u0004a\u0001\u0017\"9\u0011q\u0004\u0007A\u0002\u0005\u0005\u0012!D2pYVlg\u000eU1ui\u0016\u0014h\u000e\u0005\u0003\u0002$\u0005ERBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u000bI,w-\u001a=\u000b\t\u0005-\u0012QF\u0001\u0005kRLGN\u0003\u0002\u00020\u0005!!.\u0019<b\u0013\u0011\t\u0019$!\n\u0003\u000fA\u000bG\u000f^3s]\u0002")
public class CatalogShim_v3_0
extends CatalogShim_v2_4 {
    @Override
    public Seq<Row> getCatalogs(SparkSession spark) {
        CatalogManager catalogMgr = spark.sessionState().catalogManager();
        Object sessionCatalog = this.invoke(catalogMgr, "v2SessionCatalog", (Seq<Tuple2<Class<?>, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        CatalogPlugin defaultCatalog = catalogMgr.currentCatalog();
        Seq defaults = (Seq)((TraversableLike)((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sessionCatalog, defaultCatalog}))).distinct()).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)this.invoke(x$1, "name", (Seq<Tuple2<Class<?>, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), Seq$.MODULE$.canBuildFrom());
        Map catalogs = (Map)this.getField(catalogMgr, "catalogs");
        Iterable iterable = catalogs.keys();
        return (Seq)((TraversableLike)((SeqLike)defaults.$plus$plus$colon((Traversable)iterable, Seq$.MODULE$.canBuildFrom())).distinct()).map((Function1 & Serializable & scala.Serializable)x$3 -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x$3})), Seq$.MODULE$.canBuildFrom());
    }

    private CatalogPlugin getCatalog(SparkSession spark, String catalogName) {
        CatalogManager catalogManager = spark.sessionState().catalogManager();
        return catalogName == null || catalogName.isEmpty() ? catalogManager.currentCatalog() : catalogManager.catalog(catalogName);
    }

    @Override
    public boolean catalogExists(SparkSession spark, String catalog) {
        return spark.sessionState().catalogManager().isCatalogRegistered(catalog);
    }

    private String[][] listAllNamespaces(SupportsNamespaces catalog, String[][] namespaces) {
        String[][] stringArray;
        String[][] children = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespaces)).flatMap((Function1 & Serializable & scala.Serializable)ns -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listNamespaces(ns))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])children)).isEmpty()) {
            stringArray = namespaces;
        } else {
            String[][] stringArray2 = namespaces;
            stringArray = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.listAllNamespaces(catalog, children))).$plus$plus$colon((Traversable)Predef$.MODULE$.wrapRefArray((Object[])stringArray2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        }
        return stringArray;
    }

    private String[][] listAllNamespaces(CatalogPlugin catalog) {
        String[][] stringArray;
        CatalogPlugin catalogPlugin = catalog;
        if (catalogPlugin instanceof CatalogExtension) {
            CatalogExtension catalogExtension = (CatalogExtension)catalogPlugin;
            String[] stringArray2 = catalogExtension.defaultNamespace();
            stringArray = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalogExtension.listNamespaces((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))))).$plus$colon((Object)stringArray2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        } else if (catalogPlugin instanceof SupportsNamespaces) {
            String[][] allSchemas;
            SupportsNamespaces supportsNamespaces = (SupportsNamespaces)catalogPlugin;
            String[][] rootSchema = supportsNamespaces.listNamespaces();
            stringArray = allSchemas = this.listAllNamespaces(supportsNamespaces, rootSchema);
        } else {
            throw new MatchError((Object)catalogPlugin);
        }
        return stringArray;
    }

    private String quoteIfNeeded(String part) {
        return part.contains(".") || part.contains("`") ? new StringBuilder(2).append("`").append(part.replace("`", "``")).append("`").toString() : part;
    }

    private String[][] listNamespacesWithPattern(CatalogPlugin catalog, String schemaPattern) {
        Pattern p = new StringOps(Predef$.MODULE$.augmentString(schemaPattern)).r().pattern();
        return (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.listAllNamespaces(catalog))).filter((Function1 & Serializable & scala.Serializable)ns -> BoxesRunTime.boxToBoolean((boolean)CatalogShim_v3_0.$anonfun$listNamespacesWithPattern$1(this, p, ns))))).distinct();
    }

    private Seq<String> getSchemasWithPattern(CatalogPlugin catalog, String schemaPattern) {
        Pattern p = new StringOps(Predef$.MODULE$.augmentString(schemaPattern)).r().pattern();
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.listAllNamespaces(catalog))).flatMap((Function1 & Serializable & scala.Serializable)ns -> {
            String quoted = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ns)).map((Function1 & Serializable & scala.Serializable)part -> this.quoteIfNeeded((String)part), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(".");
            return p.matcher(quoted).matches() ? Option$.MODULE$.option2Iterable((Option)new Some((Object)quoted)) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).distinct());
    }

    @Override
    public Seq<Row> getSchemas(SparkSession spark, String catalogName, String schemaPattern) {
        Seq<String> viewMgr = this.getGlobalTempViewManager(spark, schemaPattern);
        CatalogPlugin catalog = this.getCatalog(spark, catalogName);
        Seq<String> schemas = this.getSchemasWithPattern(catalog, schemaPattern);
        return (Seq)((TraversableLike)schemas.$plus$plus(viewMgr, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$6 -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x$6, catalog.name()})), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<Row> getCatalogTablesOrViews(SparkSession spark, String catalogName, String schemaPattern, String tablePattern, Set<String> tableTypes) {
        Seq seq;
        CatalogPlugin catalog = this.getCatalog(spark, catalogName);
        String[][] namespaces = this.listNamespacesWithPattern(catalog, schemaPattern);
        CatalogPlugin catalogPlugin = catalog;
        String string = catalogPlugin.name();
        String string2 = SparkCatalogShim$.MODULE$.SESSION_CATALOG();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            seq = super.getCatalogTablesOrViews(spark, SparkCatalogShim$.MODULE$.SESSION_CATALOG(), schemaPattern, tablePattern, tableTypes);
        } else if (catalogPlugin instanceof TableCatalog) {
            TableCatalog tableCatalog = (TableCatalog)catalogPlugin;
            Pattern tp = new StringOps(Predef$.MODULE$.augmentString(tablePattern)).r().pattern();
            Identifier[] identifiers = (Identifier[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespaces)).flatMap((Function1 & Serializable & scala.Serializable)ns -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableCatalog.listTables(ns))).filter((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)CatalogShim_v3_0.$anonfun$getCatalogTablesOrViews$2($this, tp$1, i))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Identifier.class)));
            seq = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])identifiers)).map((Function1 & Serializable & scala.Serializable)ident -> {
                Table table = tableCatalog.loadTable(ident);
                String comment = table.properties().getOrDefault("comment", "");
                String schema = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).map((Function1 & Serializable & scala.Serializable)part -> this.quoteIfNeeded((String)part), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(".");
                String tableName = this.quoteIfNeeded(ident.name());
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{catalog.name(), schema, tableName, "TABLE", comment, null, null, null, null, null}));
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        } else {
            seq = (Seq)Nil$.MODULE$;
        }
        return seq;
    }

    @Override
    public Seq<Row> getColumnsByCatalog(SparkSession spark, String catalogName, String schemaPattern, String tablePattern, Pattern columnPattern) {
        Seq seq;
        CatalogPlugin catalog;
        CatalogPlugin catalogPlugin = catalog = this.getCatalog(spark, catalogName);
        String string = catalogPlugin.name();
        String string2 = SparkCatalogShim$.MODULE$.SESSION_CATALOG();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            seq = super.getColumnsByCatalog(spark, SparkCatalogShim$.MODULE$.SESSION_CATALOG(), schemaPattern, tablePattern, columnPattern);
        } else if (catalogPlugin instanceof TableCatalog) {
            TableCatalog tableCatalog = (TableCatalog)catalogPlugin;
            String[][] namespaces = this.listNamespacesWithPattern(catalog, schemaPattern);
            Pattern tp = new StringOps(Predef$.MODULE$.augmentString(tablePattern)).r().pattern();
            Identifier[] identifiers = (Identifier[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespaces)).flatMap((Function1 & Serializable & scala.Serializable)ns -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableCatalog.listTables(ns))).filter((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)CatalogShim_v3_0.$anonfun$getColumnsByCatalog$2($this, tp$2, i))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Identifier.class)));
            seq = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])identifiers)).flatMap((Function1 & Serializable & scala.Serializable)ident -> {
                Table table = tableCatalog.loadTable(ident);
                String namespace = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).map((Function1 & Serializable & scala.Serializable)part -> this.quoteIfNeeded((String)part), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(".");
                String tableName = this.quoteIfNeeded(ident.name());
                return (Seq)((TraversableLike)((TraversableLike)table.schema().zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)CatalogShim_v3_0.$anonfun$getColumnsByCatalog$5(columnPattern, f)))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    StructField f = (StructField)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Row row = this.toColumnResult(tableCatalog.name(), namespace, tableName, f, i);
                    return row;
                }, Seq$.MODULE$.canBuildFrom());
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        } else {
            throw new MatchError((Object)catalogPlugin);
        }
        return seq;
    }

    public static final /* synthetic */ boolean $anonfun$listNamespacesWithPattern$1(CatalogShim_v3_0 $this, Pattern p$1, String[] ns) {
        String quoted = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ns)).map((Function1 & Serializable & scala.Serializable)part -> $this.quoteIfNeeded((String)part), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(".");
        return p$1.matcher(quoted).matches();
    }

    public static final /* synthetic */ boolean $anonfun$getCatalogTablesOrViews$2(CatalogShim_v3_0 $this, Pattern tp$1, Identifier i) {
        return tp$1.matcher($this.quoteIfNeeded(i.name())).matches();
    }

    public static final /* synthetic */ boolean $anonfun$getColumnsByCatalog$2(CatalogShim_v3_0 $this, Pattern tp$2, Identifier i) {
        return tp$2.matcher($this.quoteIfNeeded(i.name())).matches();
    }

    public static final /* synthetic */ boolean $anonfun$getColumnsByCatalog$5(Pattern columnPattern$1, Tuple2 f) {
        return columnPattern$1.matcher(((StructField)f._1()).name()).matches();
    }
}

