/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.zookeeper;

import java.io.File;
import java.net.InetSocketAddress;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.service.AbstractService;
import org.apache.kyuubi.service.ServiceState$;
import org.apache.kyuubi.zookeeper.ZookeeperConf$;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import scala.Enumeration;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e4A\u0001F\u000b\u0001=!)Q\u0005\u0001C\u0001M!I\u0011\u0006\u0001a\u0001\u0002\u0004%IA\u000b\u0005\ne\u0001\u0001\r\u00111A\u0005\nMB\u0011\u0002\u0010\u0001A\u0002\u0003\u0005\u000b\u0015B\u0016\t\u0013u\u0002\u0001\u0019!a\u0001\n\u0013q\u0004\"\u0003\"\u0001\u0001\u0004\u0005\r\u0011\"\u0003D\u0011%)\u0005\u00011A\u0001B\u0003&q\bC\u0005G\u0001\u0001\u0007\t\u0019!C\u0005\u000f\"I\u0001\u000b\u0001a\u0001\u0002\u0004%I!\u0015\u0005\n'\u0002\u0001\r\u0011!Q!\n!Cq\u0001\u0016\u0001C\u0002\u0013%Q\u000b\u0003\u0004Z\u0001\u0001\u0006IA\u0016\u0005\n5\u0002\u0001\r\u00111A\u0005\nmC\u0011b\u001a\u0001A\u0002\u0003\u0007I\u0011\u00025\t\u0013)\u0004\u0001\u0019!A!B\u0013a\u0006\"B6\u0001\t\u0003b\u0007\"B;\u0001\t\u00032\b\"B<\u0001\t\u00032\b\"\u0002=\u0001\t\u0003Y&!E#nE\u0016$G-\u001a3[_>\\W-\u001a9fe*\u0011acF\u0001\nu>|7.Z3qKJT!\u0001G\r\u0002\r-LX/\u001e2j\u0015\tQ2$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\b\t\u0003A\rj\u0011!\t\u0006\u0003E]\tqa]3sm&\u001cW-\u0003\u0002%C\ty\u0011IY:ue\u0006\u001cGoU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0002OA\u0011\u0001\u0006A\u0007\u0002+\u0005\u0019!p[:\u0016\u0003-\u0002\"\u0001\f\u0019\u000e\u00035R!AL\u0018\u0002\rM,'O^3s\u0015\t1\u0012$\u0003\u00022[\ty!l\\8LK\u0016\u0004XM]*feZ,'/A\u0004{WN|F%Z9\u0015\u0005QR\u0004CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$\u0001B+oSRDqaO\u0002\u0002\u0002\u0003\u00071&A\u0002yIE\nAA_6tA\u0005i1/\u001a:wKJ4\u0015m\u0019;pef,\u0012a\u0010\t\u0003Y\u0001K!!Q\u0017\u0003)9KujU3sm\u0016\u00148I\u001c=o\r\u0006\u001cGo\u001c:z\u0003E\u0019XM\u001d<fe\u001a\u000b7\r^8ss~#S-\u001d\u000b\u0003i\u0011Cqa\u000f\u0004\u0002\u0002\u0003\u0007q(\u0001\btKJ4XM\u001d$bGR|'/\u001f\u0011\u0002\u001b\u0011\fG/\u0019#je\u0016\u001cGo\u001c:z+\u0005A\u0005CA%O\u001b\u0005Q%BA&M\u0003\tIwNC\u0001N\u0003\u0011Q\u0017M^1\n\u0005=S%\u0001\u0002$jY\u0016\f\u0011\u0003Z1uC\u0012K'/Z2u_JLx\fJ3r)\t!$\u000bC\u0004<\u0013\u0005\u0005\t\u0019\u0001%\u0002\u001d\u0011\fG/\u0019#je\u0016\u001cGo\u001c:zA\u0005QB-\u001a7fi\u0016$\u0015\r^1ESJ,7\r^8ss>s7\t\\8tKV\ta\u000b\u0005\u00026/&\u0011\u0001L\u000e\u0002\b\u0005>|G.Z1o\u0003m!W\r\\3uK\u0012\u000bG/\u0019#je\u0016\u001cGo\u001c:z\u001f:\u001cEn\\:fA\u0005!\u0001n\\:u+\u0005a\u0006CA/e\u001d\tq&\r\u0005\u0002`m5\t\u0001M\u0003\u0002b;\u00051AH]8pizJ!a\u0019\u001c\u0002\rA\u0013X\rZ3g\u0013\t)gM\u0001\u0004TiJLgn\u001a\u0006\u0003GZ\n\u0001\u0002[8ti~#S-\u001d\u000b\u0003i%Dqa\u000f\b\u0002\u0002\u0003\u0007A,A\u0003i_N$\b%\u0001\u0006j]&$\u0018.\u00197ju\u0016$\"\u0001N7\t\u000b9\u0004\u0002\u0019A8\u0002\t\r|gN\u001a\t\u0003aNl\u0011!\u001d\u0006\u0003e^\taaY8oM&<\u0017B\u0001;r\u0005)Y\u00150^;cS\u000e{gNZ\u0001\u0006gR\f'\u000f\u001e\u000b\u0002i\u0005!1\u000f^8q\u0003A9W\r^\"p]:,7\r^*ue&tw\r")
public class EmbeddedZookeeper
extends AbstractService {
    private ZooKeeperServer zks;
    private NIOServerCnxnFactory serverFactory;
    private File dataDirectory;
    private final boolean deleteDataDirectoryOnClose;
    private String host;

    private ZooKeeperServer zks() {
        return this.zks;
    }

    private void zks_$eq(ZooKeeperServer x$1) {
        this.zks = x$1;
    }

    private NIOServerCnxnFactory serverFactory() {
        return this.serverFactory;
    }

    private void serverFactory_$eq(NIOServerCnxnFactory x$1) {
        this.serverFactory = x$1;
    }

    private File dataDirectory() {
        return this.dataDirectory;
    }

    private void dataDirectory_$eq(File x$1) {
        this.dataDirectory = x$1;
    }

    private boolean deleteDataDirectoryOnClose() {
        return this.deleteDataDirectoryOnClose;
    }

    private String host() {
        return this.host;
    }

    private void host_$eq(String x$1) {
        this.host = x$1;
    }

    public synchronized void initialize(KyuubiConf conf) {
        this.dataDirectory_$eq(new File((String)conf.get(ZookeeperConf$.MODULE$.ZK_DATA_DIR())));
        int clientPort = BoxesRunTime.unboxToInt((Object)conf.get(ZookeeperConf$.MODULE$.ZK_CLIENT_PORT()));
        int tickTime = BoxesRunTime.unboxToInt((Object)conf.get(ZookeeperConf$.MODULE$.ZK_TICK_TIME()));
        int maxClientCnxns = BoxesRunTime.unboxToInt((Object)conf.get(ZookeeperConf$.MODULE$.ZK_MAX_CLIENT_CONNECTIONS()));
        int minSessionTimeout = BoxesRunTime.unboxToInt((Object)conf.get(ZookeeperConf$.MODULE$.ZK_MIN_SESSION_TIMEOUT()));
        int maxSessionTimeout = BoxesRunTime.unboxToInt((Object)conf.get(ZookeeperConf$.MODULE$.ZK_MAX_SESSION_TIMEOUT()));
        this.host_$eq((String)((Option)conf.get(ZookeeperConf$.MODULE$.ZK_CLIENT_PORT_ADDRESS())).getOrElse((Function0 & java.io.Serializable & Serializable)() -> Utils$.MODULE$.findLocalInetAddress().getCanonicalHostName()));
        this.zks_$eq(new ZooKeeperServer(this.dataDirectory(), this.dataDirectory(), tickTime));
        this.zks().setMinSessionTimeout(minSessionTimeout);
        this.zks().setMaxSessionTimeout(maxSessionTimeout);
        this.serverFactory_$eq(new NIOServerCnxnFactory());
        this.serverFactory().configure(new InetSocketAddress(this.host(), clientPort), maxClientCnxns);
        super.initialize(conf);
    }

    public synchronized void start() {
        this.serverFactory().startup(this.zks());
        this.info((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(15).append(this.getName()).append(" is started at ").append(this.getConnectString()).toString());
        Utils$.MODULE$.addShutdownHook(() -> this.stop(), Utils$.MODULE$.SERVER_SHUTDOWN_PRIORITY() - 1);
        super.start();
    }

    public synchronized void stop() {
        Object object;
        Enumeration.Value value = this.getServiceState();
        Enumeration.Value value2 = ServiceState$.MODULE$.STARTED();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            if (this.serverFactory() != null) {
                this.serverFactory().shutdown();
            }
            if (this.zks() != null) {
                this.zks().shutdown();
            }
            object = this.deleteDataDirectoryOnClose() ? BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.deleteDirectoryRecursively(this.dataDirectory())) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        super.stop();
    }

    public synchronized String getConnectString() {
        Predef$.MODULE$.assert(this.zks() != null, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(7).append(this.getName()).append(" is in ").append(this.getServiceState()).toString());
        return new StringBuilder(1).append(this.host()).append(":").append(this.serverFactory().getLocalPort()).toString();
    }

    public EmbeddedZookeeper() {
        super("EmbeddedZookeeper");
        this.deleteDataDirectoryOnClose = true;
    }
}

