/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.utils.ZKPaths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.ServiceDiscovery$;
import org.apache.kyuubi.ha.client.ZooKeeperAuthTypes$;
import org.apache.kyuubi.ha.client.ZooKeeperClientProvider$;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.server.KyuubiServer;
import org.apache.kyuubi.service.ServiceState$;
import org.apache.kyuubi.util.KyuubiHadoopUtils$;
import org.apache.kyuubi.util.SignalRegister$;
import org.apache.kyuubi.zookeeper.EmbeddedZookeeper;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Properties$;

public final class KyuubiServer$
implements Logging {
    public static KyuubiServer$ MODULE$;
    private final EmbeddedZookeeper zkServer;
    private KyuubiServer kyuubiServer;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new KyuubiServer$();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private EmbeddedZookeeper zkServer() {
        return this.zkServer;
    }

    public KyuubiServer kyuubiServer() {
        return this.kyuubiServer;
    }

    public void kyuubiServer_$eq(KyuubiServer x$1) {
        this.kyuubiServer = x$1;
    }

    public KyuubiServer startServer(KyuubiConf conf) {
        KyuubiConf kyuubiConf;
        if (!ServiceDiscovery$.MODULE$.supportServiceDiscovery(conf)) {
            this.zkServer().initialize(conf);
            this.zkServer().start();
            conf.set(HighAvailabilityConf$.MODULE$.HA_ZK_QUORUM(), (Object)this.zkServer().getConnectString());
            kyuubiConf = conf.set(HighAvailabilityConf$.MODULE$.HA_ZK_AUTH_TYPE(), (Object)ZooKeeperAuthTypes$.MODULE$.NONE().toString());
        } else {
            String connectionStr = (String)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_QUORUM());
            String[] addresses = connectionStr.split(",");
            Option slashOption = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(Arrays.copyOfRange((Object[])addresses, 0, addresses.length - 1))).toList().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("/")));
            if (slashOption.isDefined()) {
                throw new IllegalArgumentException(new StringBuilder(87).append("Illegal zookeeper quorum '").append(connectionStr).append("', ").append("the chroot path started with / is only allowed at the end!").toString());
            }
            int chrootIndex = connectionStr.indexOf("/");
            None$ chrootOption = chrootIndex > 0 ? new Some((Object)connectionStr.substring(chrootIndex)) : None$.MODULE$;
            chrootOption.foreach((Function1 & Serializable & scala.Serializable)chroot -> {
                KyuubiServer$.$anonfun$startServer$2(connectionStr, chrootIndex, conf, chroot);
                return BoxedUnit.UNIT;
            });
            kyuubiConf = BoxedUnit.UNIT;
        }
        KyuubiServer server = new KyuubiServer();
        try {
            server.initialize(conf);
        }
        catch (Exception e) {
            Enumeration.Value value = this.zkServer().getServiceState();
            Enumeration.Value value2 = ServiceState$.MODULE$.STARTED();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                this.zkServer().stop();
            }
            throw e;
        }
        server.start();
        Utils$.MODULE$.addShutdownHook(() -> server.stop(), Utils$.MODULE$.SERVER_SHUTDOWN_PRIORITY());
        return server;
    }

    public void main(String[] args) {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\n        |                  Welcome to\n        |  __  __                           __\n        | /\\ \\/\\ \\                         /\\ \\      __\n        | \\ \\ \\/'/'  __  __  __  __  __  __\\ \\ \\____/\\_\\\n        |  \\ \\ , <  /\\ \\/\\ \\/\\ \\/\\ \\/\\ \\/\\ \\\\ \\ '__`\\/\\ \\\n        |   \\ \\ \\\\`\\\\ \\ \\_\\ \\ \\ \\_\\ \\ \\ \\_\\ \\\\ \\ \\L\\ \\ \\ \\\n        |    \\ \\_\\ \\_\\/`____ \\ \\____/\\ \\____/ \\ \\_,__/\\ \\_\\\n        |     \\/_/\\/_/`/___/> \\/___/  \\/___/   \\/___/  \\/_/\n        |                /\\___/\n        |                \\/__/\n       ")).stripMargin());
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Version: ").append(package$.MODULE$.KYUUBI_VERSION()).append(", Revision: ").append(package$.MODULE$.REVISION()).append(", Branch: ").append(package$.MODULE$.BRANCH()).append(",").append(" Java: ").append(package$.MODULE$.JAVA_COMPILE_VERSION()).append(", Scala: ").append(package$.MODULE$.SCALA_COMPILE_VERSION()).append(",").append(" Spark: ").append(package$.MODULE$.SPARK_COMPILE_VERSION()).append(", Hadoop: ").append(package$.MODULE$.HADOOP_COMPILE_VERSION()).append(",").append(" Hive: ").append(package$.MODULE$.HIVE_COMPILE_VERSION()).toString());
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Using Scala ").append(Properties$.MODULE$.versionString()).append(", ").append(Properties$.MODULE$.javaVmName()).append(",").append(" ").append(Properties$.MODULE$.javaVersion()).toString());
        SignalRegister$.MODULE$.registerLogger(this.logger());
        KyuubiConf conf = new KyuubiConf(KyuubiConf$.MODULE$.$lessinit$greater$default$1()).loadFileDefaults();
        UserGroupInformation.setConfiguration((Configuration)KyuubiHadoopUtils$.MODULE$.newHadoopConf(conf));
        this.startServer(conf);
    }

    public static final /* synthetic */ void $anonfun$startServer$3(String chroot$1, CuratorFramework zkClient) {
        if (zkClient.checkExists().forPath(chroot$1) == null) {
            String chrootPath = ZKPaths.makePath(null, (String)chroot$1);
            try {
                ((PathAndBytesable)zkClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(chrootPath);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
            }
            catch (KeeperException e) {
                throw new KyuubiException(new StringBuilder(31).append("Failed to create chroot path '").append(chrootPath).append("'").toString(), (Throwable)e);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$startServer$2(String connectionStr$1, int chrootIndex$1, KyuubiConf conf$1, String chroot) {
        String zkConnectionForChrootCreation = connectionStr$1.substring(0, chrootIndex$1);
        KyuubiConf overrideQuorumConf = conf$1.clone().set(HighAvailabilityConf$.MODULE$.HA_ZK_QUORUM(), (Object)zkConnectionForChrootCreation);
        ZooKeeperClientProvider$.MODULE$.withZkClient(overrideQuorumConf, (Function1 & Serializable & scala.Serializable)zkClient -> {
            KyuubiServer$.$anonfun$startServer$3(chroot, zkClient);
            return BoxedUnit.UNIT;
        });
        MODULE$.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Created zookeeper chroot path ").append(chroot).toString());
    }

    private KyuubiServer$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.zkServer = new EmbeddedZookeeper();
    }
}

